/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.IfManager;
import net.sourceforge.plantuml.preproc.PreprocessorInclude;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineInsertable;
import net.sourceforge.plantuml.utils.StartUtils;

public class Preprocessor
implements ReadLine {
    private static final String ID = "[A-Za-z_][A-Za-z_0-9]*";
    private static final String ARG = "(?:\\([A-Za-z_][A-Za-z_0-9]*(?:,[A-Za-z_][A-Za-z_0-9]*)*?\\))?";
    private static final Pattern definePattern = MyPattern.cmpile("^[%s]*!define[%s]+([A-Za-z_][A-Za-z_0-9]*(?:\\([A-Za-z_][A-Za-z_0-9]*(?:,[A-Za-z_][A-Za-z_0-9]*)*?\\))?)(?:[%s]+(.*))?$");
    private static final Pattern undefPattern = MyPattern.cmpile("^[%s]*!undef[%s]+([A-Za-z_][A-Za-z_0-9]*)$");
    private static final Pattern definelongPattern = MyPattern.cmpile("^[%s]*!definelong[%s]+([A-Za-z_][A-Za-z_0-9]*(?:\\([A-Za-z_][A-Za-z_0-9]*(?:,[A-Za-z_][A-Za-z_0-9]*)*?\\))?)");
    private static final Pattern enddefinelongPattern = MyPattern.cmpile("^[%s]*!enddefinelong[%s]*$");
    private final Defines defines;
    private final PreprocessorInclude rawSource;
    private final ReadLineInsertable source;
    private int ignoreDefineDuringSeveralLines = 0;

    public Preprocessor(ReadLine reader, String charset, Defines defines, File newCurrentDir) {
        this.defines = defines;
        this.defines.saveState();
        this.rawSource = new PreprocessorInclude(reader, defines, charset, newCurrentDir);
        this.source = new ReadLineInsertable(new IfManager(this.rawSource, defines));
    }

    @Override
    public CharSequence2 readLine() throws IOException {
        Matcher m;
        CharSequence2 s = this.source.readLine();
        if (s == null) {
            return null;
        }
        if (StartUtils.isArobaseStartDiagram(s)) {
            this.defines.restoreState();
        }
        if ((m = definePattern.matcher(s)).find()) {
            return this.manageDefine(m);
        }
        m = definelongPattern.matcher(s);
        if (m.find()) {
            return this.manageDefineLong(m);
        }
        m = undefPattern.matcher(s);
        if (m.find()) {
            return this.manageUndef(m);
        }
        if (this.ignoreDefineDuringSeveralLines > 0) {
            --this.ignoreDefineDuringSeveralLines;
            return s;
        }
        List<String> result = this.defines.applyDefines(s.toString2());
        if (result.size() > 1) {
            this.ignoreDefineDuringSeveralLines = result.size() - 2;
            this.source.insert(result.subList(1, result.size() - 1), s.getLocation());
        }
        return new CharSequence2Impl(result.get(0), s.getLocation());
    }

    private CharSequence2 manageUndef(Matcher m) throws IOException {
        this.defines.undefine(m.group(1));
        return this.readLine();
    }

    private CharSequence2 manageDefineLong(Matcher m) throws IOException {
        CharSequence2 read;
        String group1 = m.group(1);
        ArrayList<String> def = new ArrayList<String>();
        do {
            if ((read = this.readLine()) == null) {
                return null;
            }
            def.add(read.toString2());
        } while (!enddefinelongPattern.matcher(read).find());
        this.defines.define(group1, def);
        return this.readLine();
    }

    private CharSequence2 manageDefine(Matcher m) throws IOException {
        String group1 = m.group(1);
        String group2 = m.group(2);
        if (group2 == null) {
            this.defines.define(group1, null);
        } else {
            List<String> strings = this.defines.applyDefines(group2);
            if (strings.size() > 1) {
                this.defines.define(group1, strings);
            } else {
                StringBuilder value = new StringBuilder(strings.get(0));
                while (StringUtils.endsWithBackslash(value.toString())) {
                    value.setLength(value.length() - 1);
                    CharSequence2 read = this.readLine();
                    value.append(read.toString2());
                }
                ArrayList<String> li = new ArrayList<String>();
                li.add(value.toString());
                this.defines.define(group1, li);
            }
        }
        return this.readLine();
    }

    public int getLineNumber() {
        return this.rawSource.getLineNumber();
    }

    @Override
    public void close() throws IOException {
        this.rawSource.close();
    }

    public Set<FileWithSuffix> getFilesUsed() {
        return Collections.unmodifiableSet(this.rawSource.getFilesUsedGlobal());
    }
}

