/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic.color;

import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;

public class ColorParser {
    private static final String COLOR_REGEXP = "#\\w+[-\\\\|/]?\\w+";
    private static final String PART2 = "#(?:\\w+[-\\\\|/]?\\w+;)?(?:(?:text|back|header|line|line\\.dashed|line\\.dotted|line\\.bold|shadowing)(?::\\w+[-\\\\|/]?\\w+)?(?:;|(?![\\w;:.])))+";
    private static final String COLORS_REGEXP = "(?:#(?:\\w+[-\\\\|/]?\\w+;)?(?:(?:text|back|header|line|line\\.dashed|line\\.dotted|line\\.bold|shadowing)(?::\\w+[-\\\\|/]?\\w+)?(?:;|(?![\\w;:.])))+)|(?:#\\w+[-\\\\|/]?\\w+)";
    private final RegexLeaf regex;
    private final String name;
    private final ColorType mainType;

    private ColorParser(String name, RegexLeaf regex, ColorType mainType) {
        this.regex = regex;
        this.name = name;
        this.mainType = mainType;
    }

    public Colors getColor(RegexResult arg, IHtmlColorSet set) {
        if (this.mainType == null) {
            throw new IllegalStateException();
        }
        String data = arg.get(this.name, 0);
        if (data == null) {
            return Colors.empty();
        }
        return new Colors(data, set, this.mainType);
    }

    public static ColorParser simpleColor(ColorType mainType) {
        return new ColorParser("COLOR", new RegexLeaf("COLOR", "((?:#(?:\\w+[-\\\\|/]?\\w+;)?(?:(?:text|back|header|line|line\\.dashed|line\\.dotted|line\\.bold|shadowing)(?::\\w+[-\\\\|/]?\\w+)?(?:;|(?![\\w;:.])))+)|(?:#\\w+[-\\\\|/]?\\w+))?"), mainType);
    }

    public static ColorParser simpleColor(String optPrefix, ColorType mainType) {
        return new ColorParser("COLOR", new RegexLeaf("COLOR", "(?:" + optPrefix + " (" + COLORS_REGEXP + "))?"), mainType);
    }

    public static RegexLeaf exp1() {
        return ColorParser.simpleColor(null).regex;
    }

    public static RegexLeaf exp2() {
        return new RegexLeaf("BACKCOLOR", "(#\\w+[-\\\\|/]?\\w+)?");
    }

    public static RegexLeaf exp3() {
        return new RegexLeaf("BACKCOLOR2", "(#\\w+[-\\\\|/]?\\w+)?");
    }

    public static RegexLeaf exp4() {
        return new RegexLeaf("COLOR", "(?:(#\\w+[-\\\\|/]?\\w+):)?");
    }

    public static RegexLeaf exp6() {
        return new RegexLeaf("COLOR", "(?:(#\\w+[-\\\\|/]?\\w+)\\|)?");
    }

    public static RegexLeaf exp7() {
        return new RegexLeaf("COLOR", "(?:(#\\w+[-\\\\|/]?\\w+))?");
    }

    public RegexLeaf getRegex() {
        return this.regex;
    }
}

