/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.geom.InflationTransform;
import net.sourceforge.plantuml.geom.Point2DInt;
import net.sourceforge.plantuml.geom.Pointable;
import net.sourceforge.plantuml.geom.XMoveable;
import net.sourceforge.plantuml.geom.kinetic.Frame;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.EntityImageFactory;
import net.sourceforge.plantuml.graph2.CubicCurveFactory;
import net.sourceforge.plantuml.graph2.MyCurve;
import net.sourceforge.plantuml.graph2.RectanglesCollection;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;

public class Graph4 {
    private static final Graphics2D dummyGraphics2D;
    private final int spaceWidth = 40;
    private final int spaceHeight = 40;
    private final double margin = 30.0;
    private final Board board;
    private final Map<ANode, ANodePoint> nodePoints = new LinkedHashMap<ANode, ANodePoint>();
    private final Map<ANodePoint, Frame> frames = new LinkedHashMap<ANodePoint, Frame>();
    private int maxRow;
    private int maxCol;
    private int addedWidth = 0;
    private int addedHeight = 0;
    private final List<MyCurve> alreadyCurve = new ArrayList<MyCurve>();

    public Graph4(Board board) {
        board.normalize();
        this.board = board;
        for (ANode n : board.getNodes()) {
            this.maxRow = Math.max(this.maxRow, n.getRow());
            this.maxCol = Math.max(this.maxCol, board.getCol(n));
        }
        for (ANode n : board.getNodes()) {
            this.nodePoints.put(n, new ANodePoint(n));
        }
        InflationTransform inflationTransform = new InflationTransform();
        for (ANodePoint nodePoint : this.nodePoints.values()) {
            Point2DInt p = nodePoint.getPosition();
            AbstractEntityImage image = this.getImage(nodePoint.getNode());
            int widthCell = (int)image.getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D)).getWidth();
            int heightCell = (int)image.getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D)).getHeight();
            if (widthCell % 2 == 1) {
                ++widthCell;
            }
            if (heightCell % 2 == 1) {
                ++heightCell;
            }
            inflationTransform.addInflationX(p.getXint(), widthCell);
            this.addedWidth += widthCell;
            inflationTransform.addInflationY(p.getYint(), heightCell);
            this.addedHeight += heightCell;
        }
        for (ANodePoint nodePoint : this.nodePoints.values()) {
            Point2DInt pos = nodePoint.getPosition();
            Point2DInt pos2 = inflationTransform.inflatePoint2DInt(pos);
            nodePoint.moveX(pos2.getXint() - pos.getXint());
            nodePoint.moveY(pos2.getYint() - pos.getYint());
        }
        for (ANodePoint point : this.nodePoints.values()) {
            double x = point.getPosition().getX();
            double y = point.getPosition().getY();
            Dimension2D dim = this.getImage(point.getNode()).getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D));
            int width = (int)dim.getWidth();
            int height = (int)dim.getHeight();
            Frame frame = new Frame(x - (double)(width / 2), y - (double)(height / 2), width, height);
            this.frames.put(point, frame);
        }
    }

    public Dimension2D getDimension() {
        double width = 40 * this.maxCol;
        int height = 40 * this.maxRow;
        return new Dimension2DDouble(width + 60.0 + (double)this.addedWidth, (double)height + 60.0 + (double)this.addedHeight);
    }

    public void draw(Graphics2D g2d) {
        g2d.translate(30.0, 30.0);
        g2d.setColor(Color.BLUE);
        long start = System.currentTimeMillis();
        this.alreadyCurve.clear();
        for (ALink link : this.getSortedLinks()) {
            ANodePoint p1 = this.nodePoints.get(link.getNode1());
            ANodePoint p2 = this.nodePoints.get(link.getNode2());
            RectanglesCollection forbidden = this.getForbidden(link);
            if (forbidden.size() != this.nodePoints.size() - 2) {
                throw new IllegalStateException();
            }
            MyCurve line = this.getCurveLink(p1, p2, forbidden);
            this.alreadyCurve.add(line);
            line.draw(g2d);
        }
        long tps5 = System.currentTimeMillis() - start;
        Log.println("TPS5 = " + tps5);
        g2d.setColor(Color.GREEN);
        for (ANodePoint nodePoint : this.nodePoints.values()) {
            Frame frame = this.frames.get(nodePoint);
            AbstractEntityImage image = this.getImage(nodePoint.getNode());
            g2d.translate(frame.getX(), frame.getY());
            image.draw(new ColorMapperIdentity(), g2d);
            g2d.translate(-frame.getX(), -frame.getY());
        }
    }

    private List<ALink> getSortedLinks() {
        final HashMap<ALink, Double> lengths = new HashMap<ALink, Double>();
        for (ALink aLink : this.board.getLinks()) {
            ANodePoint p1 = this.nodePoints.get(aLink.getNode1());
            ANodePoint p2 = this.nodePoints.get(aLink.getNode2());
            lengths.put(aLink, p1.getPosition().distance(p2.getPosition()));
        }
        ArrayList<ALink> all = new ArrayList<ALink>(lengths.keySet());
        Collections.sort(all, new Comparator<ALink>(){

            @Override
            public int compare(ALink l1, ALink l2) {
                double diff = (Double)lengths.get(l1) - (Double)lengths.get(l2);
                return (int)Math.signum(diff);
            }
        });
        return all;
    }

    private MyCurve getCurveLink(ANodePoint p1, ANodePoint p2, RectanglesCollection forbidden) {
        int y2;
        int x2;
        int y1;
        int x1 = p1.getPosition().getXint();
        CubicCurve2D.Double curve = new CubicCurve2D.Double(x1, y1 = p1.getPosition().getYint(), x1, y1, x2 = p2.getPosition().getXint(), y2 = p2.getPosition().getYint(), x2, y2);
        MyCurve result = new MyCurve(curve);
        if (result.intersects(forbidden) || result.intersects(this.alreadyCurve)) {
            CubicCurveFactory factory = new CubicCurveFactory(p1.getPosition(), p2.getPosition());
            for (Rectangle2D.Double r : forbidden) {
                factory.addForbidden(r);
            }
            for (MyCurve c : this.alreadyCurve) {
                factory.addForbidden(c);
            }
            return factory.getCubicCurve2D();
        }
        return result;
    }

    private RectanglesCollection getForbidden(ALink link) {
        RectanglesCollection result = new RectanglesCollection();
        for (Map.Entry<ANode, ANodePoint> entry : this.nodePoints.entrySet()) {
            ANode node = entry.getKey();
            if (link.getNode1().equals(node) || link.getNode2().equals(node)) continue;
            ANodePoint nodePoints = entry.getValue();
            Frame frame = this.frames.get(nodePoints);
            result.add(new Rectangle2D.Double(frame.getX(), frame.getY(), frame.getWidth(), frame.getHeight()));
        }
        return result;
    }

    private AbstractEntityImage getImage(ANode n) {
        return new EntityImageFactory().createEntityImage((IEntity)n.getUserData());
    }

    static {
        EmptyImageBuilder builder = new EmptyImageBuilder(10, 10, Color.WHITE);
        dummyGraphics2D = builder.getGraphics2D();
    }

    class ANodePoint
    implements Pointable,
    XMoveable {
        private final ANode node;
        private int deltaX = 0;
        private int deltaY = 0;

        public ANodePoint(ANode node) {
            this.node = node;
        }

        @Override
        public Point2DInt getPosition() {
            return new Point2DInt(Graph4.this.board.getCol(this.node) * 40 + this.deltaX, this.node.getRow() * 40 + this.deltaY);
        }

        @Override
        public void moveX(int delta) {
            this.deltaX += delta;
        }

        public void moveY(int delta) {
            this.deltaY += delta;
        }

        public ANode getNode() {
            return this.node;
        }
    }
}

