/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.geom.Box;
import net.sourceforge.plantuml.geom.CollectionUtils;
import net.sourceforge.plantuml.geom.Point2DInt;
import net.sourceforge.plantuml.geom.PolylineBreakeable;
import net.sourceforge.plantuml.geom.XMoveable;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graph.EntityImageFactory;
import net.sourceforge.plantuml.graph.Galaxy4;
import net.sourceforge.plantuml.graph.GeneralPathFactory;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UFont;

public class Elastane {
    private static final int STEP = 4;
    private static final int OUTER_BOX = 20;
    private final Color red = new Color(Integer.parseInt("A80036", 16));
    private final Galaxy4 galaxy;
    private final double margin = 30.0;
    private int minX = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private final Map<ANode, Box> boxes = new LinkedHashMap<ANode, Box>();
    private final Map<ALink, PolylineBreakeable> lines = new LinkedHashMap<ALink, PolylineBreakeable>();

    Elastane(Galaxy4 galaxy) {
        this.galaxy = galaxy;
    }

    public void addBox(ANode node, int w, int h) {
        int row = node.getRow();
        int col = this.galaxy.getBoard().getCol(node);
        Point2DInt pos = this.galaxy.getMainPoint(row, col);
        Box box = new Box(pos.getXint() - w / 2, pos.getYint() - h / 2, w, h);
        this.boxes.put(node, box);
        assert (!this.boxOverlap());
    }

    private double getCost() {
        if (this.boxOverlap()) {
            return Double.MAX_VALUE;
        }
        double result = 0.0;
        for (ALink alink : this.galaxy.getLines().keySet()) {
            PolylineBreakeable orig;
            PolylineBreakeable p = orig = this.lines.get(alink);
            result += this.getLength(p);
            Box b1 = this.boxes.get(alink.getNode1());
            Box b2 = this.boxes.get(alink.getNode2());
            result += this.getCostBoxIntersect(p, b1, b2);
            for (ALink alink2 : this.galaxy.getLines().keySet()) {
                PolylineBreakeable other;
                if (alink == alink2 || !p.doesTouch(other = this.lines.get(alink2))) continue;
                result += this.getLength(other);
            }
        }
        return result;
    }

    private double getLength(PolylineBreakeable mutedPolyline) {
        double len = mutedPolyline.getLength();
        assert (len > 0.0);
        return Math.log(1.0 + len);
    }

    private double getCostBoxIntersect(PolylineBreakeable polyline, Box b1, Box b2) {
        double result = 0.0;
        for (Box b : this.boxes.values()) {
            if (b == b1 || b == b2 || !polyline.intersectBox(b)) continue;
            double dist = polyline.getDistance(b);
            assert (dist >= 0.0);
            assert (dist != Double.MAX_VALUE);
            result += 100000.0 - dist;
        }
        return result;
    }

    private void initLines() {
        for (ALink alink : this.galaxy.getLines().keySet()) {
            PolylineBreakeable p = this.galaxy.getPolyline(alink);
            Box b1 = this.boxes.get(alink.getNode1());
            Box b2 = this.boxes.get(alink.getNode2());
            this.lines.put(alink, p.copy(b1, b2));
        }
    }

    private boolean boxOverlap() {
        ArrayList<Box> all = new ArrayList<Box>();
        for (Box b : this.boxes.values()) {
            all.add(b.outerBox(20));
        }
        for (int i = 0; i < all.size() - 1; ++i) {
            for (int j = i + 1; j < all.size(); ++j) {
                if (!((Box)all.get(i)).intersectBox((Box)all.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    private void moveX(Collection<XMoveable> boxes, int delta, double initCost, boolean trace) {
        for (XMoveable b : boxes) {
            b.moveX(delta);
        }
    }

    private boolean isConcerned(ALink link, Collection<XMoveable> moved) {
        Box b1 = this.boxes.get(link.getNode1());
        Box b2 = this.boxes.get(link.getNode2());
        return moved.contains(b1) && moved.contains(b2);
    }

    private boolean onePass(Collection<? extends Collection<XMoveable>> subLists) {
        boolean changed = false;
        for (Collection<XMoveable> collection : subLists) {
            double initCost = this.getCost();
            assert (this.reversable(initCost, collection));
            this.moveX(collection, 4, initCost, true);
            if (this.getCost() < initCost) {
                changed = true;
            } else {
                this.moveX(collection, -4, initCost, false);
                this.moveX(collection, -4, initCost, true);
                if (this.getCost() < initCost) {
                    changed = true;
                } else {
                    this.moveX(collection, 4, initCost, false);
                    assert (this.getCost() == initCost) : "c1=" + this.getCost() + " init=" + initCost;
                }
            }
            assert (this.getCost() <= initCost);
        }
        return changed;
    }

    private boolean reversable(double initCost, Collection<XMoveable> toMove) {
        this.moveX(toMove, 4, 0.0, false);
        this.moveX(toMove, -4, 0.0, false);
        assert (this.getCost() == initCost);
        this.moveX(toMove, 4, 0.0, false);
        this.moveX(toMove, -8, 0.0, false);
        this.moveX(toMove, 4, 0.0, false);
        assert (this.getCost() == initCost);
        return true;
    }

    private Collection<XMoveable> convertANodeSet(Set<ANode> nodesSet, Map<ALink, Collection<XMoveable>> linkMoveables) {
        HashSet<XMoveable> result = new HashSet<XMoveable>();
        for (ANode n : nodesSet) {
            assert (this.boxes.get(n) != null);
            result.add(this.boxes.get(n));
        }
        return result;
    }

    public void draw(Graphics2D g2d) {
        AffineTransform at = g2d.getTransform();
        g2d.translate((double)(-this.minX) + 30.0, (double)(-this.minY) + 30.0);
        g2d.setColor(this.red);
        for (Map.Entry<ALink, PolylineBreakeable> entry : this.lines.entrySet()) {
            ALink alink = entry.getKey();
            Link l = (Link)alink.getUserData();
            GeneralPathFactory factory = new GeneralPathFactory(l.getType());
            Box b1 = this.boxes.get(alink.getNode1());
            Box b2 = this.boxes.get(alink.getNode2());
            PolylineBreakeable polyline = entry.getValue();
            Shape shape = factory.getLink(polyline, b1, b2);
            String label = l.getLabel().get(0).toString();
            if (label != null) {
                TextBlock textBlock = Display.create(label).create(FontConfiguration.blackBlueTrue(UFont.getCurrentFont(g2d)), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
                textBlock.calculateDimension(StringBounderUtils.asStringBounder(g2d));
            }
            g2d.setColor(this.red);
            g2d.draw(shape);
        }
        g2d.setColor(Color.BLACK);
        for (Map.Entry<Object, Object> entry : this.boxes.entrySet()) {
            ANode node = (ANode)entry.getKey();
            AbstractEntityImage image = this.images(node.getRow(), this.galaxy.getBoard().getCol(node));
            assert (image != null);
            Box box = (Box)entry.getValue();
            g2d.translate(box.getX(), box.getY());
            image.draw(new ColorMapperIdentity(), g2d);
            g2d.translate(-box.getX(), -box.getY());
        }
        g2d.setTransform(at);
    }

    public void init() {
        boolean bl;
        this.initLines();
        HashSet<Set<ANode>> nodesGroups = new HashSet<Set<ANode>>();
        Collection<ANode> nodes = this.galaxy.getBoard().getNodes();
        for (ANode root : nodes) {
            for (int i = 0; i < this.galaxy.getBoard().getLinks().size(); ++i) {
                Set<ANode> set = this.galaxy.getBoard().getConnectedNodes(root, i);
                if (set.size() >= nodes.size()) continue;
                nodesGroups.add(set);
            }
        }
        ArrayList<Collection<XMoveable>> xmoveableGroups = new ArrayList<Collection<XMoveable>>();
        HashMap<ALink, Collection<XMoveable>> linkMoveables = new HashMap<ALink, Collection<XMoveable>>();
        for (Map.Entry<ALink, PolylineBreakeable> entry : this.lines.entrySet()) {
            PolylineBreakeable p = entry.getValue();
            List<XMoveable> freedoms = p.getFreedoms();
            if (freedoms.size() <= 0) continue;
            linkMoveables.put(entry.getKey(), freedoms);
            xmoveableGroups.addAll(CollectionUtils.selectUpTo(freedoms, 1));
        }
        for (Set set : nodesGroups) {
            xmoveableGroups.add(this.convertANodeSet(set, linkMoveables));
        }
        assert (this.getCost() != Double.MAX_VALUE);
        for (int i = 0; i < 3000 && (bl = this.onePass(xmoveableGroups)); ++i) {
        }
        for (Box box : this.boxes.values()) {
            this.minX = Math.min(this.minX, box.getMinX());
            this.maxX = Math.max(this.maxX, box.getMaxX());
            this.minY = Math.min(this.minY, box.getMinY());
            this.maxY = Math.max(this.maxY, box.getMaxY());
        }
        for (PolylineBreakeable polylineBreakeable : this.lines.values()) {
            this.minX = Math.min(this.minX, polylineBreakeable.getMinX());
            this.maxX = Math.max(this.maxX, polylineBreakeable.getMaxX());
            this.minY = Math.min(this.minY, polylineBreakeable.getMinY());
            this.maxY = Math.max(this.maxY, polylineBreakeable.getMaxY());
        }
    }

    private AbstractEntityImage images(int r, int c) {
        ANode n = this.galaxy.getBoard().getNodeAt(r, c);
        if (n == null) {
            return null;
        }
        return new EntityImageFactory().createEntityImage((IEntity)n.getUserData());
    }

    public Dimension2D getDimension() {
        Dimension2DDouble dim = new Dimension2DDouble((double)(this.maxX - this.minX) + 60.0, (double)(this.maxY - this.minY) + 60.0);
        Log.info("Dim=" + dim);
        return dim;
    }
}

