/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends AbstractPSystem {
    public static final String DONORS = "UDfTKa5osp0ClECLF6lIHoXMwuvi9ncxxI4tM48is3IXa9HRwMszzME5qigYZHDtW0LsGUGs-n_auOKYUPExA8wnWc-KpI5dMCiCVO1yek8UbdvEKGyxscE8ZCuyIUCWTxLuinIA0utFjpUjcChHmHgJGIv2mHDW2_dSMYwmwsO9FImvkmqdK4ugkm2xI6r3pYn4MlLNJ7CemEfyHnKF2x7ip5QwG51sT_diA6fa0Yt39b6DvnJggDpIBtIrhdFHi7OzeE_LwVPgsntWALKV1tYsV552mTL9bLypxE1pkBPsYOYCBb0CPuw-Dsjif4OenwM_DgZjaxgCxFnT6gTUr-GmQftgKrtbF_5qkd7bwXlumMHjP9Nsx2CFy7LErm8RhXgovX7Pzga3EwHYGhYNLXAwJoLMxnq5KtHxZ_grThR_GuwHgiQiF0QS9Hr8BpRvm9_ZeMc9MSc5qxlvk9plitz6s2QtF8wuyNbKTfjScPp6HJsAHuUsVJ2l557Q05lrYxusAnv_6hvOyUFwDtz-MwluBytvuOe0";

    @Override
    public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        GraphicStrings result = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, result.getBackcolor(), this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.addUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, os);
    }

    private GraphicStrings getGraphicStrings() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("<b>Special thanks to our sponsors and donors !");
        lines.add(" ");
        int i = 0;
        List<String> donors = this.getDonors();
        int maxLine = (donors.size() + 1) / 2;
        for (String d : donors) {
            lines.add(d);
            if (++i != maxLine) continue;
            lines.add(" ");
            lines.add(" ");
            i = 0;
        }
        lines.add(" ");
        UFont font = new UFont("SansSerif", 0, 12);
        GraphicStrings graphicStrings = new GraphicStrings(lines, font, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON, PSystemVersion.getPlantumlImage(), GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT);
        graphicStrings.setMaxLine(maxLine + 2);
        return graphicStrings;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        TranscoderImpl t = new TranscoderImpl();
        String s = t.decode(DONORS).replace('*', '.');
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            lines.add(st.nextToken());
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Donors)", this.getClass());
    }

    public static PSystemDonors create() {
        return new PSystemDonors();
    }
}

