/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LongCode;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.Neighborhood;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.SingleStrategy;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.utils.UniqueSequence;

final class EntityImpl
implements ILeaf,
IGroup {
    private final EntityFactory entityFactory;
    private final Code code;
    private final LongCode longCode;
    private Url url;
    private final Bodier bodier;
    private final String uid = StringUtils.getUid("cl", UniqueSequence.getValue());
    private Display display = Display.empty();
    private LeafType leafType;
    private Stereotype stereotype;
    private String generic;
    private IGroup parentContainer;
    private boolean top;
    private Code namespace2;
    private GroupType groupType;
    private boolean autonom = true;
    private boolean nearDecoration = false;
    private int xposition;
    private IEntityImage svekImage;
    private boolean removed = false;
    private USymbol symbol;
    private final int rawLayout;
    private char concurrentSeparator;
    private int layer;
    private Neighborhood neighborhood;
    private final Map<String, Display> tips = new LinkedHashMap<String, Display>();
    private Colors colors = Colors.empty();

    @Override
    public final boolean isTop() {
        this.checkNotGroup();
        return this.top;
    }

    @Override
    public final void setTop(boolean top) {
        this.checkNotGroup();
        this.top = top;
    }

    private EntityImpl(EntityFactory entityFactory, Code code, Bodier bodier, IGroup parentContainer, LongCode longCode, String namespaceSeparator, int rawLayout) {
        if (code == null) {
            throw new IllegalArgumentException();
        }
        this.entityFactory = entityFactory;
        this.bodier = bodier;
        this.code = code;
        this.parentContainer = parentContainer;
        this.longCode = longCode;
        this.rawLayout = rawLayout;
    }

    EntityImpl(EntityFactory entityFactory, Code code, Bodier bodier, IGroup parentContainer, LeafType leafType, LongCode longCode, String namespaceSeparator, int rawLayout) {
        this(entityFactory, code, bodier, parentContainer, longCode, namespaceSeparator, rawLayout);
        this.leafType = leafType;
    }

    EntityImpl(EntityFactory entityFactory, Code code, Bodier bodier, IGroup parentContainer, GroupType groupType, Code namespace2, LongCode longCode, String namespaceSeparator, int rawLayout) {
        this(entityFactory, code, bodier, parentContainer, longCode, namespaceSeparator, rawLayout);
        this.groupType = groupType;
        this.namespace2 = namespace2;
    }

    @Override
    public void setContainer(IGroup container) {
        this.checkNotGroup();
        if (container == null) {
            throw new IllegalArgumentException();
        }
        this.parentContainer = container;
    }

    @Override
    public LeafType getEntityType() {
        return this.leafType;
    }

    @Override
    public void muteToType(LeafType newType, USymbol newSymbol) {
        this.checkNotGroup();
        if (newType == null) {
            throw new IllegalArgumentException();
        }
        if (this.leafType != LeafType.STILL_UNKNOWN) {
            if (this.leafType != LeafType.ANNOTATION && this.leafType != LeafType.ABSTRACT_CLASS && this.leafType != LeafType.CLASS && this.leafType != LeafType.ENUM && this.leafType != LeafType.INTERFACE) {
                throw new IllegalArgumentException("type=" + (Object)((Object)this.leafType));
            }
            if (newType != LeafType.ANNOTATION && newType != LeafType.ABSTRACT_CLASS && newType != LeafType.CLASS && newType != LeafType.ENUM && newType != LeafType.INTERFACE && newType != LeafType.OBJECT) {
                throw new IllegalArgumentException("newtype=" + (Object)((Object)newType));
            }
        }
        if (this.leafType == LeafType.CLASS && newType == LeafType.OBJECT) {
            this.bodier.muteClassToObject();
        }
        this.leafType = newType;
        this.symbol = newSymbol;
    }

    @Override
    public Code getCode() {
        return this.code;
    }

    @Override
    public Display getDisplay() {
        return this.display;
    }

    @Override
    public void setDisplay(Display display) {
        this.display = display;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public Stereotype getStereotype() {
        return this.stereotype;
    }

    @Override
    public final void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    @Override
    public final IGroup getParentContainer() {
        if (this.parentContainer == null) {
            throw new IllegalArgumentException();
        }
        return this.parentContainer;
    }

    public String toString() {
        return this.code + " " + this.display + "(" + (Object)((Object)this.leafType) + ") " + this.xposition + " " + this.getUid();
    }

    @Override
    public final Url getUrl99() {
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        if (!Display.isNull(this.display) && this.display.hasUrl()) {
            return true;
        }
        if (this.bodier.hasUrl()) {
            return true;
        }
        return this.url != null;
    }

    @Override
    public final void addUrl(Url url) {
        this.url = url;
    }

    @Override
    public final boolean hasNearDecoration() {
        this.checkNotGroup();
        return this.nearDecoration;
    }

    @Override
    public final void setNearDecoration(boolean nearDecoration) {
        this.nearDecoration = nearDecoration;
    }

    @Override
    public int getXposition() {
        this.checkNotGroup();
        return this.xposition;
    }

    @Override
    public void setXposition(int pos) {
        this.checkNotGroup();
        this.xposition = pos;
    }

    @Override
    public final IEntityImage getSvekImage() {
        this.checkNotGroup();
        return this.svekImage;
    }

    @Override
    public final void setSvekImage(IEntityImage svekImage) {
        this.checkNotGroup();
        this.svekImage = svekImage;
    }

    @Override
    public final void setGeneric(String generic) {
        this.checkNotGroup();
        this.generic = generic;
    }

    @Override
    public final String getGeneric() {
        this.checkNotGroup();
        return this.generic;
    }

    @Override
    public Bodier getBodier() {
        return this.bodier;
    }

    @Override
    public EntityPosition getEntityPosition() {
        this.checkNotGroup();
        if (this.leafType != LeafType.STATE) {
            return EntityPosition.NORMAL;
        }
        if (this.getParentContainer() instanceof GroupRoot) {
            return EntityPosition.NORMAL;
        }
        Stereotype stereotype = this.getStereotype();
        if (stereotype == null) {
            return EntityPosition.NORMAL;
        }
        String label = stereotype.getLabel(false);
        if ("<<entrypoint>>".equalsIgnoreCase(label)) {
            return EntityPosition.ENTRY_POINT;
        }
        if ("<<exitpoint>>".equalsIgnoreCase(label)) {
            return EntityPosition.EXIT_POINT;
        }
        return EntityPosition.NORMAL;
    }

    private void checkGroup() {
        if (!this.isGroup()) {
            throw new UnsupportedOperationException();
        }
    }

    private void checkNotGroup() {
        if (this.isGroup()) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean containsLeafRecurse(ILeaf leaf) {
        if (leaf == null) {
            throw new IllegalArgumentException();
        }
        if (leaf.isGroup()) {
            throw new IllegalArgumentException();
        }
        this.checkGroup();
        if (leaf.getParentContainer() == this) {
            return true;
        }
        for (IGroup child : this.getChildren()) {
            if (!child.containsLeafRecurse(leaf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ILeaf> getLeafsDirect() {
        this.checkGroup();
        ArrayList<ILeaf> result = new ArrayList<ILeaf>();
        for (ILeaf ent : this.entityFactory.getLeafs().values()) {
            if (ent.isGroup()) {
                throw new IllegalStateException();
            }
            if (ent.getParentContainer() != this) continue;
            result.add(ent);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Collection<IGroup> getChildren() {
        this.checkGroup();
        ArrayList<IGroup> result = new ArrayList<IGroup>();
        for (IGroup g : this.entityFactory.getGroups().values()) {
            if (g == this || g.getParentContainer() != this) continue;
            result.add(g);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public void moveEntitiesTo(IGroup dest) {
        this.checkGroup();
        if (!dest.isGroup()) {
            throw new UnsupportedOperationException();
        }
        for (ILeaf ent : this.getLeafsDirect()) {
            ((EntityImpl)ent).parentContainer = dest;
        }
        Iterator<IEntity> iterator = dest.getChildren().iterator();
        if (iterator.hasNext()) {
            IGroup g = (IGroup)iterator.next();
            throw new IllegalStateException();
        }
        for (IGroup g : this.getChildren()) {
            if (g == dest) continue;
            ((EntityImpl)g).parentContainer = dest;
        }
    }

    @Override
    public int size() {
        this.checkGroup();
        return this.getLeafsDirect().size();
    }

    @Override
    public GroupType getGroupType() {
        this.checkGroup();
        return this.groupType;
    }

    @Override
    public Code getNamespace2() {
        this.checkGroup();
        return this.namespace2;
    }

    @Override
    public boolean isAutonom() {
        this.checkGroup();
        return this.autonom;
    }

    @Override
    public void setAutonom(boolean autonom) {
        this.autonom = autonom;
    }

    @Override
    public PackageStyle getPackageStyle() {
        this.checkGroup();
        if (this.stereotype == null) {
            return null;
        }
        return this.stereotype.getPackageStyle();
    }

    @Override
    public boolean isGroup() {
        if (this.groupType != null && this.leafType != null) {
            throw new IllegalStateException();
        }
        if (this.groupType != null) {
            return true;
        }
        if (this.leafType != null) {
            return false;
        }
        throw new IllegalStateException();
    }

    @Override
    public void overideImage(IEntityImage img, LeafType leafType) {
        this.checkGroup();
        this.svekImage = img;
        this.url = null;
        for (Link link : new ArrayList<Link>(this.entityFactory.getLinks())) {
            if (!EntityUtils.isPureInnerLink12(this, link)) continue;
            this.entityFactory.removeLink(link);
        }
        this.entityFactory.removeGroup(this.getCode());
        for (ILeaf ent : new ArrayList<ILeaf>(this.entityFactory.getLeafs().values())) {
            if (this == ent || this != ent.getParentContainer()) continue;
            this.entityFactory.removeLeaf(ent.getCode());
        }
        this.entityFactory.addLeaf(this);
        this.groupType = null;
        this.leafType = leafType;
    }

    void muteToGroup(Code namespace2, GroupType groupType, IGroup parentContainer) {
        this.checkNotGroup();
        if (!parentContainer.isGroup()) {
            throw new IllegalArgumentException();
        }
        this.namespace2 = namespace2;
        this.groupType = groupType;
        this.leafType = null;
        this.parentContainer = parentContainer;
    }

    @Override
    public boolean isHidden() {
        if (this.entityFactory.isHidden(this.leafType)) {
            return true;
        }
        if (this.stereotype != null) {
            return this.stereotype.isHidden();
        }
        return false;
    }

    @Override
    public USymbol getUSymbol() {
        if (this.symbol != null && this.stereotype != null && this.stereotype.getSprite() != null) {
            return this.symbol.withStereoAlignment(HorizontalAlignment.RIGHT);
        }
        return this.symbol;
    }

    @Override
    public void setUSymbol(USymbol symbol) {
        this.symbol = symbol;
    }

    @Override
    public SingleStrategy getSingleStrategy() {
        return SingleStrategy.SQUARRE;
    }

    @Override
    public boolean isRemoved() {
        if (this.isGroup()) {
            if (this.getLeafsDirect().size() == 0) {
                return false;
            }
            for (ILeaf leaf : this.getLeafsDirect()) {
                if (leaf.isRemoved()) continue;
                return false;
            }
            for (IGroup g : this.getChildren()) {
                if (g.isRemoved()) continue;
                return false;
            }
            return true;
        }
        return this.removed;
    }

    @Override
    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    @Override
    public int getHectorLayer() {
        return this.layer;
    }

    @Override
    public void setHectorLayer(int layer) {
        this.layer = layer;
        if (layer > 1000) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public LongCode getLongCode() {
        return this.longCode;
    }

    private FontParam getTitleFontParam() {
        if (this.symbol != null) {
            return this.symbol.getFontParam();
        }
        return this.getGroupType() == GroupType.STATE ? FontParam.STATE : FontParam.PACKAGE;
    }

    @Override
    public FontConfiguration getFontConfigurationForTitle(ISkinParam skinParam) {
        FontParam fontParam = this.getTitleFontParam();
        HtmlColor fontHtmlColor = skinParam.getFontHtmlColor(this.getStereotype(), fontParam, FontParam.PACKAGE);
        UFont font = skinParam.getFont(this.getStereotype(), true, fontParam, FontParam.PACKAGE);
        FontConfiguration fontConfiguration = new FontConfiguration(font, fontHtmlColor, skinParam.getHyperlinkColor(), skinParam.useUnderlineForHyperlink(), skinParam.getTabSize());
        return fontConfiguration;
    }

    @Override
    public final int getRawLayout() {
        return this.rawLayout;
    }

    @Override
    public char getConcurrentSeparator() {
        return this.concurrentSeparator;
    }

    @Override
    public void setConcurrentSeparator(char separator) {
        this.concurrentSeparator = separator;
    }

    @Override
    public void setNeighborhood(Neighborhood neighborhood) {
        this.neighborhood = neighborhood;
    }

    @Override
    public Neighborhood getNeighborhood() {
        return this.neighborhood;
    }

    @Override
    public void putTip(String member, Display display) {
        this.tips.put(member, display);
    }

    @Override
    public Map<String, Display> getTips() {
        return Collections.unmodifiableMap(this.tips);
    }

    @Override
    public Colors getColors(ISkinParam skinParam) {
        return this.colors;
    }

    @Override
    public void setColors(Colors colors) {
        this.colors = colors;
    }

    @Override
    public void setSpecificColorTOBEREMOVED(ColorType type, HtmlColor color) {
        if (color != null) {
            this.colors = this.colors.add(type, color);
        }
    }

    @Override
    @Deprecated
    public void applyStroke(String s) {
        throw new UnsupportedOperationException();
    }
}

