/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizLayoutStrategy;
import net.sourceforge.plantuml.cucadiagram.dot.OS;

class OSLinux
extends OS {
    OSLinux() {
    }

    @Override
    File getExecutable(GraphvizLayoutStrategy strategy) {
        File result = strategy.getSystemForcedExecutable();
        if (result != null) {
            return result;
        }
        String fileName = this.getFileName(strategy);
        File usrLocalBin = new File("/usr/local/bin/" + fileName);
        if (usrLocalBin.exists()) {
            return usrLocalBin;
        }
        File usrBin = new File("/usr/bin/" + fileName);
        return usrBin;
    }

    @Override
    String getFileName(GraphvizLayoutStrategy strategy) {
        return StringUtils.goLowerCase(strategy.name());
    }

    @Override
    public String getCommand(GraphvizLayoutStrategy strategy) {
        return this.getExecutable(strategy).getAbsolutePath();
    }
}

