/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note.sequence;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.EventWithDeactivate;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public final class FactorySequenceNoteOnArrowCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left)[%s]*"), ColorParser.exp1(), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left)[%s]*"), ColorParser.exp1(), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram system, RegexResult arg) {
                return FactorySequenceNoteOnArrowCommand.this.executeInternal(system, arg, BlocLines.getWithNewlines(arg.get("NOTE", 0)));
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^[%s]*end[%s]?note$";
            }

            @Override
            public CommandExecutionResult executeNow(SequenceDiagram system, BlocLines lines) {
                RegexResult line0 = this.getStartingPattern().matcher(StringUtils.trin(lines.getFirst499()));
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                return FactorySequenceNoteOnArrowCommand.this.executeInternal(system, line0, lines);
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram system, RegexResult line0, BlocLines lines) {
        EventWithDeactivate m = system.getLastEventWithDeactivate();
        if (m instanceof AbstractMessage) {
            Url url;
            NotePosition position = NotePosition.valueOf(StringUtils.goUpperCase(line0.get("POSITION", 0)));
            if (lines.size() > 0) {
                UrlBuilder urlBuilder = new UrlBuilder(system.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                url = urlBuilder.getUrl(lines.getFirst499().toString());
            } else {
                url = null;
            }
            if (url != null) {
                lines = lines.subExtract(1, 0);
            }
            ((AbstractMessage)m).setNote(lines.toDisplay(), position, line0.get("COLOR", 0), url);
        }
        return CommandExecutionResult.ok();
    }
}

