/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

public final class CommandLinkClass
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    public CommandLinkClass(UmlDiagramType umlDiagramType) {
        super(CommandLinkClass.getRegexConcat(umlDiagramType));
    }

    private static RegexConcat getRegexConcat(UmlDiagramType umlDiagramType) {
        return new RegexConcat(new RegexLeaf("HEADER", "^(?:@([\\d.]+)[%s]+)?"), new RegexOr(new RegexLeaf("ENT1", "(?:" + CommandLinkClass.optionalKeywords(umlDiagramType) + "[%s]+)?" + CommandLinkClass.getClassIdentifier()), new RegexLeaf("COUPLE1", "\\([%s]*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)[%s]*,[%s]*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)[%s]*\\)")), new RegexLeaf("[%s]*"), new RegexLeaf("FIRST_LABEL", "(?:[%g]([^%g]+)[%g])?"), new RegexLeaf("[%s]*"), new RegexConcat(new RegexLeaf("ARROW_HEAD1", "([%s]+o|[#\\[<*+^]|[<\\[]\\|)?"), new RegexLeaf("ARROW_BODY1", "([-=.]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|bold|hidden|norank)(?:,#\\w+|,dotted|,dashed|,bold|,hidden|,norank)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(left|right|up|down|le?|ri?|up?|do?)?"), new RegexLeaf("INSIDE", "(?:(0|\\(0\\)|\\(0|0\\))(?=[-=.~]))?"), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|bold|hidden|norank)(?:,#\\w+|,dotted|,dashed|,bold|,hidden|,norank)*)\\])?"), new RegexLeaf("ARROW_BODY2", "([-=.]*)"), new RegexLeaf("ARROW_HEAD2", "(o[%s]+|[#\\]>*+^]|\\|[>\\]])?")), new RegexLeaf("[%s]*"), new RegexLeaf("SECOND_LABEL", "(?:[%g]([^%g]+)[%g])?"), new RegexLeaf("[%s]*"), new RegexOr(new RegexLeaf("ENT2", "(?:" + CommandLinkClass.optionalKeywords(umlDiagramType) + "[%s]+)?" + CommandLinkClass.getClassIdentifier()), new RegexLeaf("COUPLE2", "\\([%s]*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)[%s]*,[%s]*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)[%s]*\\)")), new RegexLeaf("[%s]*"), CommandLinkClass.color().getRegex(), new RegexLeaf("[%s]*"), new RegexLeaf("LABEL_LINK", "(?::[%s]*(.+))?"), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.LINE);
    }

    private static String getClassIdentifier() {
        return "(" + CommandLinkClass.getSeparator() + "?[\\p{L}0-9_$]+(?:" + CommandLinkClass.getSeparator() + "[\\p{L}0-9_$]+)*|[%g][^%g]+[%g])";
    }

    private static String getSeparator() {
        return "(?:\\.|::)";
    }

    private static String optionalKeywords(UmlDiagramType type) {
        if (type == UmlDiagramType.CLASS) {
            return "(interface|enum|annotation|abstract[%s]+class|abstract|class|object)";
        }
        if (type == UmlDiagramType.OBJECT) {
            return "(object)";
        }
        throw new IllegalArgumentException();
    }

    private LeafType getTypeIfObject(String type) {
        if ("object".equalsIgnoreCase(type)) {
            return LeafType.OBJECT;
        }
        return null;
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        LeafType type;
        IEntity cl2;
        Code ent1 = Code.of(arg.get("ENT1", 1));
        Code ent2 = Code.of(arg.get("ENT2", 1));
        if (ent1 == null) {
            return this.executeArgSpecial1(diagram, arg);
        }
        if (ent2 == null) {
            return this.executeArgSpecial2(diagram, arg);
        }
        ent1 = ent1.eventuallyRemoveStartingAndEndingDoubleQuote("\"");
        ent2 = ent2.eventuallyRemoveStartingAndEndingDoubleQuote("\"");
        if (diagram.isGroup(ent1) && diagram.isGroup(ent2)) {
            return this.executePackageLink(diagram, arg);
        }
        String type1 = arg.get("ENT1", 0);
        LeafType typeIfObject1 = this.getTypeIfObject(type1);
        IEntity cl1 = diagram.isGroup(ent1) ? diagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT1", 1), "\""))) : diagram.getOrCreateLeaf(ent1, typeIfObject1, null);
        String type2 = arg.get("ENT2", 0);
        LeafType typeIfObject2 = this.getTypeIfObject(type2);
        if (!diagram.leafExist(ent2) && cl1.getEntityType() == LeafType.OBJECT && typeIfObject2 == null) {
            typeIfObject2 = LeafType.OBJECT;
        }
        IEntity iEntity = cl2 = diagram.isGroup(ent2) ? diagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT2", 1), "\""))) : diagram.getOrCreateLeaf(ent2, typeIfObject2, null);
        if (arg.get("ENT1", 0) != null && (type = LeafType.getLeafType(arg.get("ENT1", 0))) != LeafType.OBJECT) {
            ((ILeaf)cl1).muteToType(type, null);
        }
        if (arg.get("ENT2", 0) != null && (type = LeafType.getLeafType(arg.get("ENT2", 0))) != LeafType.OBJECT) {
            ((ILeaf)cl2).muteToType(type, null);
        }
        Colors colors = CommandLinkClass.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        LinkType linkType = this.getLinkType(arg);
        Direction dir = this.getDirection(arg);
        int queue = dir == Direction.LEFT || dir == Direction.RIGHT ? 1 : this.getQueueLength(arg);
        String firstLabel = arg.get("FIRST_LABEL", 0);
        String secondLabel = arg.get("SECOND_LABEL", 0);
        String labelLink = null;
        if (arg.get("LABEL_LINK", 0) != null) {
            labelLink = arg.get("LABEL_LINK", 0);
            if (firstLabel == null && secondLabel == null) {
                Pattern p1 = MyPattern.cmpile("^[%g]([^%g]+)[%g]([^%g]+)[%g]([^%g]+)[%g]$");
                Matcher m1 = p1.matcher(labelLink);
                if (m1.matches()) {
                    firstLabel = m1.group(1);
                    labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m1.group(2)), "\""));
                    secondLabel = m1.group(3);
                } else {
                    Pattern p2 = MyPattern.cmpile("^[%g]([^%g]+)[%g]([^%g]+)$");
                    Matcher m2 = p2.matcher(labelLink);
                    if (m2.matches()) {
                        firstLabel = m2.group(1);
                        labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m2.group(2)), "\""));
                        secondLabel = null;
                    } else {
                        Pattern p3 = MyPattern.cmpile("^([^%g]+)[%g]([^%g]+)[%g]$");
                        Matcher m3 = p3.matcher(labelLink);
                        if (m3.matches()) {
                            firstLabel = null;
                            labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m3.group(1)), "\""));
                            secondLabel = m3.group(2);
                        }
                    }
                }
            }
            labelLink = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(labelLink, "\"");
        }
        LinkArrow linkArrow = LinkArrow.NONE;
        if ("<".equals(labelLink)) {
            linkArrow = LinkArrow.BACKWARD;
            labelLink = null;
        } else if (">".equals(labelLink)) {
            linkArrow = LinkArrow.DIRECT_NORMAL;
            labelLink = null;
        } else if (labelLink != null && labelLink.startsWith("< ")) {
            linkArrow = LinkArrow.BACKWARD;
            labelLink = StringUtils.trin(labelLink.substring(2));
        } else if (labelLink != null && labelLink.startsWith("> ")) {
            linkArrow = LinkArrow.DIRECT_NORMAL;
            labelLink = StringUtils.trin(labelLink.substring(2));
        } else if (labelLink != null && labelLink.endsWith(" >")) {
            linkArrow = LinkArrow.DIRECT_NORMAL;
            labelLink = StringUtils.trin(labelLink.substring(0, labelLink.length() - 2));
        } else if (labelLink != null && labelLink.endsWith(" <")) {
            linkArrow = LinkArrow.BACKWARD;
            labelLink = StringUtils.trin(labelLink.substring(0, labelLink.length() - 2));
        }
        Link link = new Link(cl1, cl2, linkType, Display.getWithNewlines(labelLink), queue, firstLabel, secondLabel, diagram.getLabeldistance(), diagram.getLabelangle());
        if (dir == Direction.LEFT || dir == Direction.UP) {
            link = link.getInv();
        }
        link.setLinkArrow(linkArrow);
        colors = CommandLinkClass.applyStyle(arg.getLazzy("ARROW_STYLE", 0), link, colors);
        link.setColors(colors);
        this.addLink(diagram, link, arg.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private void addLink(AbstractClassOrObjectDiagram diagram, Link link, String weight) {
        diagram.addLink(link);
        if (weight != null) {
            link.setWeight(Double.parseDouble(weight));
        }
    }

    private CommandExecutionResult executePackageLink(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        IGroup cl1 = diagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT1", 1), "\"")));
        IGroup cl2 = diagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT2", 1), "\"")));
        LinkType linkType = this.getLinkType(arg);
        Direction dir = this.getDirection(arg);
        int queue = dir == Direction.LEFT || dir == Direction.RIGHT ? 1 : this.getQueueLength(arg);
        Colors colors = CommandLinkClass.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        Display labelLink = Display.getWithNewlines(arg.get("LABEL_LINK", 0));
        String firstLabel = arg.get("FIRST_LABEL", 0);
        String secondLabel = arg.get("SECOND_LABEL", 0);
        Link link = new Link(cl1, cl2, linkType, labelLink, queue, firstLabel, secondLabel, diagram.getLabeldistance(), diagram.getLabelangle());
        diagram.resetPragmaLabel();
        colors = CommandLinkClass.applyStyle(arg.getLazzy("ARROW_STYLE", 0), link, colors);
        link.setColors(colors);
        this.addLink(diagram, link, arg.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial1(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        Display label;
        LinkType linkType;
        Code clName1 = Code.of(arg.get("COUPLE1", 0));
        Code clName2 = Code.of(arg.get("COUPLE1", 1));
        if (!diagram.leafExist(clName1)) {
            return CommandExecutionResult.error("No class " + clName1);
        }
        if (!diagram.leafExist(clName2)) {
            return CommandExecutionResult.error("No class " + clName2);
        }
        Code ent2 = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT2", 1), "\""));
        IEntity cl2 = diagram.getOrCreateLeaf(ent2, null, null);
        boolean result = diagram.associationClass(1, clName1, clName2, cl2, linkType = this.getLinkType(arg), label = Display.getWithNewlines(arg.get("LABEL_LINK", 0)));
        if (!result) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial2(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        Display label;
        LinkType linkType;
        Code clName1 = Code.of(arg.get("COUPLE2", 0));
        Code clName2 = Code.of(arg.get("COUPLE2", 1));
        if (!diagram.leafExist(clName1)) {
            return CommandExecutionResult.error("No class " + clName1);
        }
        if (!diagram.leafExist(clName2)) {
            return CommandExecutionResult.error("No class " + clName2);
        }
        Code ent1 = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT1", 1), "\""));
        IEntity cl1 = diagram.getOrCreateLeaf(ent1, null, null);
        boolean result = diagram.associationClass(2, clName1, clName2, cl1, linkType = this.getLinkType(arg), label = Display.getWithNewlines(arg.get("LABEL_LINK", 0)));
        if (!result) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private LinkDecor getDecors1(String s) {
        if (s == null) {
            return LinkDecor.NONE;
        }
        if ("<|".equals(s = StringUtils.trin(s))) {
            return LinkDecor.EXTENDS;
        }
        if ("<".equals(s)) {
            return LinkDecor.ARROW;
        }
        if ("^".equals(s)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(s)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(s)) {
            return LinkDecor.AGREGATION;
        }
        if ("*".equals(s)) {
            return LinkDecor.COMPOSITION;
        }
        if ("#".equals(s)) {
            return LinkDecor.SQUARRE;
        }
        return LinkDecor.NONE;
    }

    private LinkDecor getDecors2(String s) {
        if (s == null) {
            return LinkDecor.NONE;
        }
        if ("|>".equals(s = StringUtils.trin(s))) {
            return LinkDecor.EXTENDS;
        }
        if (">".equals(s)) {
            return LinkDecor.ARROW;
        }
        if ("^".equals(s)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(s)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(s)) {
            return LinkDecor.AGREGATION;
        }
        if ("*".equals(s)) {
            return LinkDecor.COMPOSITION;
        }
        if ("#".equals(s)) {
            return LinkDecor.SQUARRE;
        }
        return LinkDecor.NONE;
    }

    private LinkType getLinkType(RegexResult arg) {
        String middle;
        LinkDecor decors1 = this.getDecors1(arg.get("ARROW_HEAD1", 0));
        LinkDecor decors2 = this.getDecors2(arg.get("ARROW_HEAD2", 0));
        LinkType result = new LinkType(decors2, decors1);
        if (arg.get("ARROW_BODY1", 0).contains(".") || arg.get("ARROW_BODY2", 0).contains(".")) {
            result = result.getDashed();
        }
        if ("0".equals(middle = arg.get("INSIDE", 0))) {
            result = result.withMiddleCircle();
        } else if ("0)".equals(middle)) {
            result = result.withMiddleCircleCircled1();
        } else if ("(0".equals(middle)) {
            result = result.withMiddleCircleCircled2();
        } else if ("(0)".equals(middle)) {
            result = result.withMiddleCircleCircled();
        }
        return result;
    }

    private int getQueueLength(RegexResult arg) {
        String s = this.getFullArrow(arg);
        s = s.replaceAll("[^-.=]", "");
        return s.length();
    }

    private Direction getDirection(RegexResult arg) {
        LinkDecor decors1 = this.getDecors1(arg.get("ARROW_HEAD1", 0));
        LinkDecor decors2 = this.getDecors2(arg.get("ARROW_HEAD2", 0));
        String s = this.getFullArrow(arg);
        if ((s = s.replaceAll("[^-.=\\w]", "")).startsWith("o")) {
            s = s.substring(1);
        }
        if (s.endsWith("o")) {
            s = s.substring(0, s.length() - 1);
        }
        Direction result = StringUtils.getQueueDirection(s);
        if (this.isInversed(decors1, decors2) && s.matches(".*\\w.*")) {
            result = result.getInv();
        }
        return result;
    }

    private String getFullArrow(RegexResult arg) {
        return CommandLinkClass.notNull(arg.get("ARROW_HEAD1", 0)) + CommandLinkClass.notNull(arg.get("ARROW_BODY1", 0)) + CommandLinkClass.notNull(arg.get("ARROW_DIRECTION", 0)) + CommandLinkClass.notNull(arg.get("ARROW_BODY2", 0)) + CommandLinkClass.notNull(arg.get("ARROW_HEAD2", 0));
    }

    public static String notNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    @Deprecated
    public static Colors applyStyle(String arrowStyle, Link link) {
        return CommandLinkClass.applyStyle(arrowStyle, link, null);
    }

    public static Colors applyStyle(String arrowStyle, Link link, Colors colors) {
        if (arrowStyle == null) {
            return colors;
        }
        StringTokenizer st = new StringTokenizer(arrowStyle, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equalsIgnoreCase("dashed")) {
                link.goDashed();
                continue;
            }
            if (s.equalsIgnoreCase("bold")) {
                link.goBold();
                continue;
            }
            if (s.equalsIgnoreCase("dotted")) {
                link.goDotted();
                continue;
            }
            if (s.equalsIgnoreCase("hidden")) {
                link.goHidden();
                continue;
            }
            if (s.equalsIgnoreCase("norank")) {
                link.goNorank();
                continue;
            }
            link.setSpecificColor(s);
            if (colors == null) continue;
            colors = colors.add(ColorType.LINE, HtmlColorSet.getInstance().getColorIfValid(s));
        }
        return colors;
    }

    private boolean isInversed(LinkDecor decors1, LinkDecor decors2) {
        if (decors1 == LinkDecor.ARROW && decors2 != LinkDecor.ARROW) {
            return true;
        }
        if (decors2 == LinkDecor.AGREGATION) {
            return true;
        }
        if (decors2 == LinkDecor.COMPOSITION) {
            return true;
        }
        return decors2 == LinkDecor.PLUS;
    }
}

