/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringUtils;

public class Pragma {
    private final Map<String, String> values = new LinkedHashMap<String, String>();

    public void define(String name, String value) {
        this.values.put(name, value);
        if (name.equalsIgnoreCase("graphviz_dot")) {
            OptionFlags.getInstance().setDotExecutable(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(value));
        }
    }

    public boolean isDefine(String name) {
        return this.values.containsKey(name);
    }

    public void undefine(String name) {
        this.values.remove(name);
    }

    public String getValue(String name) {
        return this.values.get(name);
    }

    public boolean horizontalLineBetweenDifferentPackageAllowed() {
        return this.isDefine("horizontallinebetweendifferentpackageallowed");
    }

    public boolean useVerticalIf() {
        String teoz = this.getValue("useverticalif");
        return "true".equalsIgnoreCase(teoz) || "on".equalsIgnoreCase(teoz);
    }

    public boolean useTeozLayout() {
        String teoz = this.getValue("teoz");
        return "true".equalsIgnoreCase(teoz) || "on".equalsIgnoreCase(teoz);
    }
}

