/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.LineLocation;

public class LineLocationImpl
implements LineLocation {
    private final String desc;
    private final int position;
    private final LineLocation parent;

    public String toString() {
        if (this.desc == null) {
            return "[?] : " + this.position;
        }
        return this.desc + " : " + this.position;
    }

    public LineLocationImpl(String desc, LineLocation parent) {
        this(desc, parent, -1);
    }

    private LineLocationImpl(String desc, LineLocation parent, int position) {
        this.parent = parent;
        this.desc = desc;
        this.position = position;
    }

    public LineLocationImpl oneLineRead() {
        return new LineLocationImpl(this.desc, this.parent, this.position + 1);
    }

    public static LineLocation fromLine(CharSequence cs) {
        if (cs instanceof CharSequence2) {
            return ((CharSequence2)cs).getLocation();
        }
        return null;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public LineLocation getParent() {
        return this.parent;
    }
}

