/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageLollipopInterfaceEye2
extends AbstractEntityImage {
    public static final double SIZE = 14.0;
    private final TextBlock desc;
    private final TextBlock stereo;
    private final SymbolContext ctx;
    private final Url url;

    public EntityImageLollipopInterfaceEye2(ILeaf entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, skinParam);
        USymbol symbol;
        Stereotype stereotype = entity.getStereotype();
        USymbol uSymbol = entity.getUSymbol() == null ? (skinParam.useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1) : (symbol = entity.getUSymbol());
        if (symbol == null) {
            throw new IllegalArgumentException();
        }
        this.desc = new BodyEnhanced(entity.getDisplay(), symbol.getFontParam(), skinParam, HorizontalAlignment.CENTER, stereotype, symbol.manageHorizontalLine(), false, false);
        this.url = entity.getUrl99();
        HtmlColor backcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), symbol.getColorParamBack(), this.getStereo());
        }
        HtmlColor forecolor = SkinParamUtils.getColor(this.getSkinParam(), symbol.getColorParamBorder(), this.getStereo());
        this.ctx = new SymbolContext(backcolor, forecolor).withStroke(new UStroke(1.5)).withShadow(this.getSkinParam().shadowing());
        this.stereo = stereotype != null && stereotype.getLabel(false) != null && portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().useGuillemet())).create(new FontConfiguration(this.getSkinParam(), symbol.getFontParamStereotype(), stereotype), HorizontalAlignment.CENTER, skinParam) : TextBlockUtils.empty(0.0, 0.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(14.0, 14.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        UEllipse circle = new UEllipse(14.0, 14.0);
        if (this.getSkinParam().shadowing()) {
            circle.setDeltaShadow(4.0);
        }
        this.ctx.apply(ug).draw(circle);
        Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double x1 = 7.0 - dimDesc.getWidth() / 2.0;
        double y1 = 19.599999999999998;
        this.desc.drawU(ug.apply(new UTranslate(x1, 19.599999999999998)));
        Dimension2D dimStereo = this.stereo.calculateDimension(ug.getStringBounder());
        double x2 = 7.0 - dimStereo.getWidth() / 2.0;
        double y2 = -dimStereo.getHeight();
        this.stereo.drawU(ug.apply(new UTranslate(x2, y2)));
        if (this.url != null) {
            ug.closeAction();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }

    @Override
    public int getShield() {
        return 0;
    }
}

