/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Hideable;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.IShapePseudo;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.image.EntityImageDescription;
import net.sourceforge.plantuml.svek.image.EntityImageStateBorder;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UPolygon;

public class Shape
implements Positionable,
IShapePseudo,
Hideable {
    private final ShapeType type;
    private final double width;
    private final double height;
    private final String uid;
    private final int color;
    private double minX;
    private double minY;
    private final int shield;
    private final EntityPosition entityPosition;
    private final IEntityImage image;
    private Cluster cluster;
    private final boolean top;
    private Shadowable octagon;

    public EntityPosition getEntityPosition() {
        return this.entityPosition;
    }

    public final Cluster getCluster() {
        return this.cluster;
    }

    public final void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public String toString() {
        return super.toString() + " " + this.image + " " + (Object)((Object)this.type);
    }

    public Shape(IEntityImage image, ShapeType type, double width, double height, ColorSequence colorSequence, boolean top, int shield, EntityPosition entityPosition) {
        this.entityPosition = entityPosition;
        this.image = image;
        this.top = top;
        this.type = type;
        this.width = width;
        this.height = height;
        this.color = colorSequence.getValue();
        this.uid = String.format("sh%04d", this.color);
        this.shield = shield;
        if (shield > 0 && type != ShapeType.RECTANGLE) {
            throw new IllegalArgumentException();
        }
    }

    public final ShapeType getType() {
        return this.type;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    @Override
    public void appendShape(StringBuilder sb) {
        if (this.type == ShapeType.RECTANGLE && this.shield > 0) {
            this.appendHtml(sb);
            return;
        }
        sb.append(this.uid);
        sb.append(" [");
        this.appendShapeInternal(sb);
        sb.append(",");
        sb.append("label=\"\"");
        sb.append(",");
        sb.append("width=" + SvekUtils.pixelToInches(this.getWidth()));
        sb.append(",");
        sb.append("height=" + SvekUtils.pixelToInches(this.getHeight()));
        sb.append(",");
        sb.append("color=\"" + StringUtils.getAsHtml(this.color) + "\"");
        sb.append("];");
        SvekUtils.println(sb);
    }

    private void appendHtml(StringBuilder sb) {
        sb.append(this.uid);
        sb.append(" [");
        sb.append("shape=plaintext,");
        sb.append("label=<");
        this.appendLabelHtml(sb);
        sb.append(">");
        sb.append("];");
        SvekUtils.println(sb);
    }

    private void appendLabelHtml(StringBuilder sb) {
        sb.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
        sb.append("<TR>");
        this.appendTd(sb);
        this.appendTd(sb, this.shield, this.shield);
        this.appendTd(sb);
        sb.append("</TR>");
        sb.append("<TR>");
        this.appendTd(sb, this.shield, this.shield);
        sb.append("<TD BGCOLOR=\"" + StringUtils.getAsHtml(this.color) + "\"");
        sb.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + this.getWidth() + "\" HEIGHT=\"" + this.getHeight() + "\"");
        sb.append(" PORT=\"h\">");
        sb.append("</TD>");
        this.appendTd(sb, this.shield, this.shield);
        sb.append("</TR>");
        sb.append("<TR>");
        this.appendTd(sb);
        this.appendTd(sb, this.shield, this.shield);
        this.appendTd(sb);
        sb.append("</TR>");
        sb.append("</TABLE>");
    }

    private void appendTd(StringBuilder sb, int w, int h) {
        sb.append("<TD");
        sb.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + w + "\" HEIGHT=\"" + h + "\"");
        sb.append(">");
        sb.append("</TD>");
    }

    private void appendTd(StringBuilder sb) {
        sb.append("<TD>");
        sb.append("</TD>");
    }

    private void appendShapeInternal(StringBuilder sb) {
        if (this.type == ShapeType.RECTANGLE && this.shield > 0) {
            throw new UnsupportedOperationException();
        }
        if (this.type == ShapeType.RECTANGLE || this.type == ShapeType.FOLDER) {
            sb.append("shape=rect");
        } else if (this.type == ShapeType.OCTAGON) {
            sb.append("shape=octagon");
        } else if (this.type == ShapeType.DIAMOND) {
            sb.append("shape=diamond");
        } else if (this.type == ShapeType.CIRCLE) {
            sb.append("shape=circle");
        } else if (this.type == ShapeType.CIRCLE_IN_RECT) {
            sb.append("shape=circle");
        } else if (this.type == ShapeType.OVAL) {
            sb.append("shape=ellipse");
        } else if (this.type == ShapeType.ROUND_RECTANGLE) {
            sb.append("shape=rect,style=rounded");
        } else {
            throw new IllegalStateException(this.type.toString());
        }
    }

    @Override
    public final String getUid() {
        if (this.uid == null) {
            throw new IllegalStateException();
        }
        return this.uid;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public IEntityImage getImage() {
        return this.image;
    }

    public final boolean isTop() {
        return this.top;
    }

    @Override
    public Point2D getPosition() {
        return new Point2D.Double(this.minX, this.minY);
    }

    @Override
    public Dimension2D getSize() {
        return new Dimension2DDouble(this.width, this.height);
    }

    public ClusterPosition getClusterPosition() {
        return new ClusterPosition(this.minX, this.minY, this.minX + this.width, this.minY + this.height);
    }

    public boolean isShielded() {
        return this.shield > 0;
    }

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        this.minX += deltaX;
        this.minY += deltaY;
    }

    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        EntityImageStateBorder im = (EntityImageStateBorder)this.image;
        return im.getMaxWidthFromLabelForEntryExit(stringBounder);
    }

    @Override
    public boolean isHidden() {
        return this.image.isHidden();
    }

    public void setOctagon(double minX, double minY, List<Point2D.Double> points) {
        this.octagon = new UPolygon(points).translate(-minX, -minY);
    }

    public Shadowable getOctagon() {
        return this.octagon;
    }

    public Point2D getPoint2D(double x, double y) {
        return new Point2D.Double(this.minX + x, this.minY + y);
    }

    public Point2D projection(Point2D pt, StringBounder stringBounder) {
        if (this.getType() != ShapeType.FOLDER) {
            return pt;
        }
        ClusterPosition clusterPosition = new ClusterPosition(this.minX, this.minY, this.minX + this.width, this.minY + this.height);
        if (clusterPosition.isPointJustUpper(pt)) {
            Dimension2D dimName = ((EntityImageDescription)this.image).getNameDimension(stringBounder);
            if (pt.getX() < this.minX + dimName.getWidth()) {
                return pt;
            }
            return new Point2D.Double(pt.getX(), pt.getY() + dimName.getHeight() + 4.0);
        }
        return pt;
    }
}

