/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifierActivity;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifierState;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.DecorateEntityImage;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UFont;

public final class CucaDiagramFileMakerSvek
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private static final StringBounder stringBounder;
    private String warningOrError;

    public CucaDiagramFileMakerSvek(CucaDiagram diagram) throws IOException {
        this.diagram = diagram;
    }

    @Override
    public ImageData createFile(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        try {
            return this.createFileInternal(os, dotStrings, fileFormatOption);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    private CucaDiagramFileMakerSvek2 buildCucaDiagramFileMakerSvek2(DotMode dotMode) {
        DotData dotData = new DotData(this.diagram.getEntityFactory().getRootGroup(), this.getOrderedLinks(), this.diagram.getLeafsvalues(), this.diagram.getUmlDiagramType(), this.diagram.getSkinParam(), this.diagram, this.diagram, this.diagram.getColorMapper(), this.diagram.getEntityFactory(), this.diagram.isHideEmptyDescriptionForState(), dotMode, this.diagram.getNamespaceSeparator(), this.diagram.getPragma());
        CucaDiagramFileMakerSvek2 svek2 = new CucaDiagramFileMakerSvek2(dotData, this.diagram.getEntityFactory(), this.diagram.getSource(), this.diagram.getPragma());
        return svek2;
    }

    private ImageData createFileInternal(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            new CucaDiagramSimplifierActivity(this.diagram, dotStrings);
        } else if (this.diagram.getUmlDiagramType() == UmlDiagramType.STATE) {
            new CucaDiagramSimplifierState(this.diagram, dotStrings);
        }
        CucaDiagramFileMakerSvek2 svek2 = this.buildCucaDiagramFileMakerSvek2(DotMode.NORMAL);
        TextBlockBackcolored result = svek2.createFile(this.diagram.getDotStringSkek());
        if (result instanceof GraphvizCrash) {
            svek2 = this.buildCucaDiagramFileMakerSvek2(DotMode.NO_LEFT_RIGHT);
            result = svek2.createFile(this.diagram.getDotStringSkek());
        }
        result = this.addLegend(result);
        result = this.addTitle(result);
        result = this.addHeaderAndFooter(result);
        String widthwarning = this.diagram.getSkinParam().getValue("widthwarning");
        this.warningOrError = widthwarning != null && widthwarning.matches("\\d+") ? svek2.getBibliotekon().getWarningOrError(Integer.parseInt(widthwarning)) : null;
        Dimension2D dim = result.calculateDimension(stringBounder);
        double scale = this.getScale(fileFormatOption, dim);
        ImageBuilder imageBuilder = new ImageBuilder(this.diagram.getSkinParam().getColorMapper(), scale, result.getBackcolor(), fileFormatOption.isWithMetadata() ? this.diagram.getMetadata() : null, this.warningOrError, 0.0, 10.0, this.diagram.getAnimation(), this.diagram.getSkinParam().handwritten());
        imageBuilder.addUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, os);
    }

    private List<Link> getOrderedLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link l : this.diagram.getLinks()) {
            this.addLinkNew(result, l);
        }
        return result;
    }

    private void addLinkNew(List<Link> result, Link link) {
        for (int i = 0; i < result.size(); ++i) {
            Link other = result.get(i);
            if (!other.sameConnections(link)) continue;
            while (i < result.size() && result.get(i).sameConnections(link)) {
                ++i;
            }
            if (i == result.size()) {
                result.add(link);
            } else {
                result.add(i, link);
            }
            return;
        }
        result.add(link);
    }

    private String getWarningOrError() {
        return this.warningOrError;
    }

    private TextBlockBackcolored addHeaderAndFooter(TextBlockBackcolored original) {
        Display footer = this.diagram.getFooter();
        Display header = this.diagram.getHeader();
        if (Display.isNull(footer) && Display.isNull(header)) {
            return original;
        }
        TextBlock textFooter = Display.isNull(footer) ? null : footer.create(new FontConfiguration(this.diagram.getSkinParam(), FontParam.FOOTER, null), this.diagram.getFooterAlignment(), this.diagram.getSkinParam());
        TextBlock textHeader = Display.isNull(header) ? null : header.create(new FontConfiguration(this.diagram.getSkinParam(), FontParam.HEADER, null), this.diagram.getHeaderAlignment(), this.diagram.getSkinParam());
        return new DecorateEntityImage(original, textHeader, this.diagram.getHeaderAlignment(), textFooter, this.diagram.getFooterAlignment());
    }

    private TextBlockBackcolored addTitle(TextBlockBackcolored original) {
        Display title = this.diagram.getTitle();
        if (Display.isNull(title)) {
            return original;
        }
        TextBlock text = title.create(new FontConfiguration(this.diagram.getSkinParam(), FontParam.TITLE, null), HorizontalAlignment.CENTER, this.diagram.getSkinParam());
        return DecorateEntityImage.addTop(original, text, HorizontalAlignment.CENTER);
    }

    private TextBlockBackcolored addLegend(TextBlockBackcolored original) {
        Display legend = this.diagram.getLegend();
        if (Display.isNull(legend)) {
            return original;
        }
        TextBlock text = EntityImageLegend.create(legend, this.diagram.getSkinParam());
        return DecorateEntityImage.add(original, text, this.diagram.getLegendAlignment(), this.diagram.getLegendVerticalAlignment());
    }

    private final UFont getFont(FontParam fontParam) {
        ISkinParam skinParam = this.diagram.getSkinParam();
        return skinParam.getFont(null, false, fontParam);
    }

    private final HtmlColor getFontColor(FontParam fontParam, Stereotype stereo) {
        ISkinParam skinParam = this.diagram.getSkinParam();
        return skinParam.getFontHtmlColor(stereo, fontParam);
    }

    private double getScale(FileFormatOption fileFormatOption, Dimension2D dim) {
        Scale diagScale = this.diagram.getScale();
        double scale = diagScale == null ? this.diagram.getDpiFactor(fileFormatOption) : diagScale.getScale(dim.getWidth(), dim.getHeight());
        return scale;
    }

    static {
        EmptyImageBuilder builder = new EmptyImageBuilder(10, 10, Color.WHITE);
        stringBounder = StringBounderUtils.asStringBounder(builder.getGraphics2D());
    }
}

