/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.util.ArrayList;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;

class GrayComponent
extends AbstractComponent {
    private static final UFont NORMAL = new UFont("SansSerif", 0, 7);
    private final ComponentType type;

    public GrayComponent(ComponentType type) {
        this.type = type;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(new UChangeBackColor(HtmlColorUtils.LIGHT_GRAY)).apply(new UChangeColor(HtmlColorUtils.BLACK));
        ug.draw(new URectangle(this.getPreferredWidth(stringBounder), this.getPreferredHeight(stringBounder)));
        String n = this.type.name();
        int split = 9;
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < n.length(); i += 9) {
            strings.add(n.substring(i, Math.min(i + 9, n.length())));
        }
        TextBlock textBlock = Display.create(strings).create(FontConfiguration.blackBlueTrue(NORMAL), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        textBlock.drawU(ug);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return 42.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return 42.0;
    }
}

