/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project2.Day;
import net.sourceforge.plantuml.project2.TimeLine;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TimeHeaderMonth
extends AbstractTextBlock
implements TextBlock {
    private final Day start;
    private final Day end;
    private final TimeLine timeline;
    private final double dayWidth;
    private final UFont font = new UFont("Serif", 0, 9);
    private final FontConfiguration fontConfig = FontConfiguration.blackBlueTrue(this.font);

    public TimeHeaderMonth(Day start, Day end, TimeLine timeline, double dayWidth) {
        this.start = start;
        this.end = end;
        this.timeline = timeline;
        this.dayWidth = dayWidth;
    }

    @Override
    public void drawU(UGraphic ug) {
        int n = 0;
        String last = null;
        double pendingX = -1.0;
        Day d = this.start;
        while (d.compareTo(this.end) <= 0) {
            String text = "" + d.getMonth().name();
            if (pendingX == -1.0) {
                pendingX = (double)n * this.dayWidth;
                last = text;
            }
            ug = ug.apply(new UChangeColor(HtmlColorUtils.BLACK));
            ug = ug.apply(new UChangeBackColor(HtmlColorUtils.WHITE));
            if (!text.equals(last)) {
                this.manage(ug, 0.0, 0.0, n, last, pendingX);
                pendingX = (double)n * this.dayWidth;
            }
            last = text;
            ++n;
            d = (Day)this.timeline.next(d);
        }
        this.manage(ug, 0.0, 0.0, n, last, pendingX);
    }

    private void manage(UGraphic ug, double x, double y, int n, String last, double pendingX) {
        double width = (double)n * this.dayWidth - pendingX;
        ug.apply(new UTranslate(x + pendingX, y)).draw(new URectangle(width, this.getHeight()));
        TextBlock b = Display.create(last).create(this.fontConfig, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        Dimension2D dimText = b.calculateDimension(ug.getStringBounder());
        double diffX = width - dimText.getWidth();
        double diffY = this.getHeight() - dimText.getHeight();
        b.drawU(ug.apply(new UTranslate(x + pendingX + diffX / 2.0, y + diffY / 2.0)));
    }

    private double getHeight() {
        return 20.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        int n = 0;
        Day d = this.start;
        while (d.compareTo(this.end) <= 0) {
            ++n;
            d = (Day)this.timeline.next(d);
        }
        return new Dimension2DDouble((double)n * this.dayWidth, this.getHeight());
    }
}

