/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.project2.Day;
import net.sourceforge.plantuml.project2.TimeConverter;
import net.sourceforge.plantuml.project2.TimeElement;
import net.sourceforge.plantuml.project2.TimeLine;

public class TimeConverterDay
implements TimeConverter {
    private Day biggest;
    private Day smallest;
    private final double dayWith;
    private final Map<Day, Integer> map1 = new HashMap<Day, Integer>();
    private final Map<Integer, Day> map2 = new HashMap<Integer, Day>();
    private final TimeLine timeLine;

    public TimeConverterDay(TimeLine timeLine, Day start, double dayWith) {
        this.timeLine = timeLine;
        this.dayWith = dayWith;
        this.biggest = start;
        this.smallest = start;
        this.putDay(start, 0);
    }

    private int getPosition(Day d) {
        int n;
        Integer result = this.map1.get(d);
        if (result != null) {
            return result;
        }
        while (d.compareTo(this.biggest) > 0) {
            n = this.getPosition(this.biggest);
            this.biggest = this.biggest.next();
            if (!this.timeLine.isClosed(this.biggest)) {
                ++n;
            }
            this.putDay(this.biggest, n);
        }
        while (d.compareTo(this.smallest) < 0) {
            n = this.getPosition(this.smallest);
            this.smallest = this.smallest.previous();
            if (!this.timeLine.isClosed(this.smallest)) {
                --n;
            }
            this.putDay(this.smallest, n);
        }
        result = this.map1.get(d);
        if (result != null) {
            return result;
        }
        throw new UnsupportedOperationException();
    }

    private void putDay(Day d, int n) {
        this.map1.put(d, n);
        this.map2.put(n, d);
    }

    @Override
    public Day getCorrespondingElement(long position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getStartPosition(TimeElement timeElement) {
        return (double)this.getPosition((Day)timeElement) * this.dayWith;
    }

    @Override
    public double getEndPosition(TimeElement timeElement) {
        return (double)(this.getPosition((Day)timeElement) + 1) * this.dayWith;
    }
}

