/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.hector.Box2D;
import net.sourceforge.plantuml.hector.Pin;
import net.sourceforge.plantuml.hector.PinFactory;
import net.sourceforge.plantuml.hector.PinLink;
import net.sourceforge.plantuml.hector.Skeleton;
import net.sourceforge.plantuml.hector.SkeletonBuilder;
import net.sourceforge.plantuml.hector.SkeletonConfiguration;
import net.sourceforge.plantuml.hector.SkeletonConfigurationUtils;
import net.sourceforge.plantuml.hector.SmartConnection;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CucaDiagramFileMakerHector4
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private SkeletonConfiguration configuration;
    private double singleWidth;
    private double singleHeight;
    private double nodeMargin = 40.0;
    private final Map<Pin, IEntityImage> images = new LinkedHashMap<Pin, IEntityImage>();
    private final Map<Pin, Box2D> boxes = new LinkedHashMap<Pin, Box2D>();
    private final Map<Link, PinLink> links = new LinkedHashMap<Link, PinLink>();
    private final List<Box2D> forbidden = new ArrayList<Box2D>();

    public CucaDiagramFileMakerHector4(CucaDiagram diagram) {
        this.diagram = diagram;
    }

    private double getX(Pin pin) {
        return this.singleWidth * (double)this.configuration.getCol(pin);
    }

    private double getY(Pin pin) {
        return this.singleHeight * (double)pin.getRow();
    }

    private double getCenterX(Pin pin) {
        return this.singleWidth * (double)this.configuration.getCol(pin) + this.singleWidth / 2.0;
    }

    private double getCenterY(Pin pin) {
        return this.singleHeight * (double)pin.getRow() + this.singleHeight / 2.0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImageData createFile(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        double y;
        double x;
        Dimension2D dimImage;
        IEntityImage im;
        Pin pin;
        void var7_10;
        PinFactory pinFactory = new PinFactory();
        SkeletonBuilder skeletonBuilder = new SkeletonBuilder();
        this.links.clear();
        for (Link link : this.diagram.getLinks()) {
            PinLink pinLink = pinFactory.createPinLink(link);
            this.links.put(link, pinLink);
            skeletonBuilder.add(pinLink);
        }
        Skeleton skeleton = skeletonBuilder.createSkeletons().get(0);
        this.configuration = SkeletonConfigurationUtils.getBest(skeleton);
        this.singleWidth = 0.0;
        this.singleHeight = 0.0;
        this.images.clear();
        for (Pin pin2 : skeleton.getPins()) {
            ILeaf leaf = (ILeaf)pin2.getUserData();
            IEntityImage image = this.computeImage(leaf);
            Dimension2D dim = TextBlockUtils.getDimension(image);
            if (dim.getWidth() > this.singleWidth) {
                this.singleWidth = dim.getWidth();
            }
            if (dim.getHeight() > this.singleHeight) {
                this.singleHeight = dim.getHeight();
            }
            this.images.put(pin2, image);
        }
        this.singleHeight += this.nodeMargin;
        this.singleWidth += this.nodeMargin;
        MinMax minMax = MinMax.getEmpty(false);
        for (Pin pin3 : skeleton.getPins()) {
            MinMax minMax3 = var7_10.addPoint(this.getX(pin3), this.getY(pin3));
            minMax3 = minMax3.addPoint(this.getX(pin3) + this.singleWidth, this.getY(pin3) + this.singleHeight);
        }
        double d = 10.0;
        Dimension2DDouble dimTotal = new Dimension2DDouble(20.0 + var7_10.getMaxX(), 20.0 + var7_10.getMaxY());
        UGraphic ug = null;
        ug = (UGraphic2)ug.apply(new UTranslate(10.0, 10.0));
        this.forbidden.clear();
        for (Map.Entry<Pin, IEntityImage> entry : this.images.entrySet()) {
            pin = entry.getKey();
            im = entry.getValue();
            dimImage = im.calculateDimension(ug.getStringBounder());
            x = this.getX(pin) + (this.singleWidth - dimImage.getWidth()) / 2.0;
            y = this.getY(pin) + (this.singleHeight - dimImage.getHeight()) / 2.0;
            Box2D box = Box2D.create(x, y, dimImage);
            this.boxes.put(pin, box);
            this.forbidden.add(box);
        }
        for (PinLink pinLink : skeleton.getPinLinks()) {
            this.drawPinLink(ug, pinLink);
        }
        for (Map.Entry entry : this.images.entrySet()) {
            pin = (Pin)entry.getKey();
            im = (IEntityImage)entry.getValue();
            dimImage = im.calculateDimension(ug.getStringBounder());
            x = this.getX(pin) + (this.singleWidth - dimImage.getWidth()) / 2.0;
            y = this.getY(pin) + (this.singleHeight - dimImage.getHeight()) / 2.0;
            im.drawU(ug.apply(new UTranslate(x, y)));
        }
        throw new UnsupportedOperationException();
    }

    private void drawPinLink(UGraphic ug, PinLink pinLink) {
        double x1 = this.getCenterX(pinLink.getPin1());
        double y1 = this.getCenterY(pinLink.getPin1());
        double x2 = this.getCenterX(pinLink.getPin2());
        double y2 = this.getCenterY(pinLink.getPin2());
        Rose rose = new Rose();
        HtmlColor color = rose.getHtmlColor(this.diagram.getSkinParam(), ColorParam.classArrow);
        ArrayList<Box2D> b = new ArrayList<Box2D>(this.forbidden);
        b.remove(this.boxes.get(pinLink.getPin1()));
        b.remove(this.boxes.get(pinLink.getPin2()));
        SmartConnection connection = new SmartConnection(x1, y1, x2, y2, b);
        connection.draw(ug, color);
    }

    private IEntityImage computeImage(ILeaf leaf) {
        IEntityImage image = CucaDiagramFileMakerSvek2.createEntityImageBlock(leaf, this.diagram.getSkinParam(), false, this.diagram, null, null, null);
        return image;
    }
}

