/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.AbstractGraphviz;

class GraphvizWindows
extends AbstractGraphviz {
    @Override
    protected File specificDotExe() {
        File result = GraphvizWindows.searchInDir(new File("c:/Program Files"));
        if (result != null) {
            return result;
        }
        File result86 = GraphvizWindows.searchInDir(new File("c:/Program Files (x86)"));
        if (result86 != null) {
            return result86;
        }
        File resultEclipse = GraphvizWindows.searchInDir(new File("c:/eclipse/graphviz"));
        if (resultEclipse != null) {
            return resultEclipse;
        }
        return null;
    }

    private static File searchInDir(File programFile) {
        if (!programFile.exists() || !programFile.isDirectory()) {
            return null;
        }
        ArrayList<File> dots = new ArrayList<File>();
        for (File f : programFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && StringUtils.goLowerCase(pathname.getName()).startsWith("graphviz");
            }
        })) {
            File result = new File(new File(f, "bin"), "dot.exe");
            if (!result.exists() || !result.canRead()) continue;
            dots.add(result.getAbsoluteFile());
        }
        return GraphvizWindows.higherVersion(dots);
    }

    static File higherVersion(List<File> dots) {
        if (dots.size() == 0) {
            return null;
        }
        Collections.sort(dots, Collections.reverseOrder());
        return dots.get(0);
    }

    GraphvizWindows(String dotString, String ... type) {
        super(dotString, type);
    }
}

