/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityGender;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Magma;
import net.sourceforge.plantuml.cucadiagram.MagmaList;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramTxtMaker;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;

public abstract class CucaDiagram
extends UmlDiagram
implements GroupHierarchy,
PortionShower {
    private int horizontalPages = 1;
    private int verticalPages = 1;
    private final Set<LeafType> hiddenType = new HashSet<LeafType>();
    protected final EntityFactory entityFactory = new EntityFactory(this.hiddenType);
    protected IGroup currentGroup = this.entityFactory.getRootGroup();
    private boolean visibilityModifierPresent;
    private String warningOrError;
    private final List<HideOrShow> hideOrShows = new ArrayList<HideOrShow>();
    private final Set<VisibilityModifier> hides = new HashSet<VisibilityModifier>();
    private ILeaf lastEntity = null;

    public abstract IEntity getOrCreateLeaf(Code var1, LeafType var2, USymbol var3);

    public String getNamespaceSeparator() {
        return null;
    }

    @Override
    public boolean hasUrl() {
        for (IEntity iEntity : this.getGroups(true)) {
            if (!iEntity.hasUrl()) continue;
            return true;
        }
        for (IEntity iEntity : this.getLeafs().values()) {
            if (!iEntity.hasUrl()) continue;
            return true;
        }
        for (Link link : this.getLinks()) {
            if (!link.hasUrl()) continue;
            return true;
        }
        return false;
    }

    protected final ILeaf getOrCreateLeafDefault(Code code, LeafType type, USymbol symbol) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        ILeaf result = this.getLeafs().get(code);
        if (result == null) {
            result = this.createLeafInternal(code, Display.getWithNewlines(code), type, this.getCurrentGroup(), symbol);
            result.setUSymbol(symbol);
        }
        if (result.getEntityType() == LeafType.CLASS && type == LeafType.OBJECT) {
            result.muteToType(type, symbol);
        }
        this.lastEntity = result;
        return result;
    }

    public ILeaf createLeaf(Code code, Display display, LeafType type, USymbol symbol) {
        if (this.getLeafs().containsKey(code)) {
            throw new IllegalArgumentException("Already known: " + code);
        }
        return this.createLeafInternal(code, display, type, this.getCurrentGroup(), symbol);
    }

    protected final ILeaf createLeafInternal(Code code, Display display, LeafType type, IGroup group, USymbol symbol) {
        if (Display.isNull(display)) {
            display = Display.getWithNewlines(code);
        }
        ILeaf leaf = this.entityFactory.createLeaf(code, display, type, group, this.getHides(), this.getNamespaceSeparator());
        this.entityFactory.addLeaf(leaf);
        this.lastEntity = leaf;
        leaf.setUSymbol(symbol);
        return leaf;
    }

    public boolean leafExist(Code code) {
        return this.getLeafs().containsKey(code);
    }

    @Override
    public final Collection<IGroup> getChildrenGroups(IGroup parent) {
        ArrayList<IGroup> result = new ArrayList<IGroup>();
        for (IGroup gg : this.getGroups(false)) {
            if (gg.getParentContainer() != parent) continue;
            result.add(gg);
        }
        return Collections.unmodifiableCollection(result);
    }

    public final IGroup getOrCreateGroup(Code code, Display display, GroupType type, IGroup parent) {
        IGroup g;
        this.currentGroup = g = this.getOrCreateGroupInternal(code, display, null, type, parent);
        return g;
    }

    private IGroup getOrCreateGroupInternal(Code code, Display display, Code namespace2, GroupType type, IGroup parent) {
        IGroup result = this.entityFactory.getGroups().get(code);
        if (result != null) {
            return result;
        }
        if (this.entityFactory.getLeafs().containsKey(code)) {
            result = this.entityFactory.muteToGroup(code, namespace2, type, parent);
            result.setDisplay(display);
        } else {
            result = this.entityFactory.createGroup(code, display, namespace2, type, parent, this.getHides(), this.getNamespaceSeparator());
        }
        this.entityFactory.addGroup(result);
        return result;
    }

    public final IGroup getCurrentGroup() {
        return this.currentGroup;
    }

    public final IGroup getGroup(Code code) {
        IGroup p = this.entityFactory.getGroups().get(code);
        if (p == null) {
            throw new IllegalArgumentException();
        }
        return p;
    }

    public void endGroup() {
        if (EntityUtils.groupRoot(this.currentGroup)) {
            Log.error("No parent group");
            return;
        }
        this.currentGroup = this.currentGroup.getParentContainer();
    }

    public final boolean isGroup(Code code) {
        return this.entityFactory.getGroups().containsKey(code);
    }

    public final Collection<IGroup> getGroups(boolean withRootGroup) {
        if (!withRootGroup) {
            return this.entityFactory.getGroups().values();
        }
        ArrayList<IGroup> result = new ArrayList<IGroup>();
        result.add(this.getRootGroup());
        result.addAll(this.entityFactory.getGroups().values());
        return Collections.unmodifiableCollection(result);
    }

    public IGroup getRootGroup() {
        return this.entityFactory.getRootGroup();
    }

    protected final Map<Code, ILeaf> getLeafs() {
        return this.entityFactory.getLeafs();
    }

    public Collection<ILeaf> getLeafsvalues() {
        return this.getLeafs().values();
    }

    public final int getLeafssize() {
        return this.getLeafs().size();
    }

    public final ILeaf getLeafsget(Code code) {
        return this.getLeafs().get(code);
    }

    public final void addLink(Link link) {
        this.entityFactory.addLink(link);
    }

    protected final void removeLink(Link link) {
        this.entityFactory.removeLink(link);
    }

    public final List<Link> getLinks() {
        return this.entityFactory.getLinks();
    }

    public final int getHorizontalPages() {
        return this.horizontalPages;
    }

    public final void setHorizontalPages(int horizontalPages) {
        this.horizontalPages = horizontalPages;
    }

    public final int getVerticalPages() {
        return this.verticalPages;
    }

    public final void setVerticalPages(int verticalPages) {
        this.verticalPages = verticalPages;
    }

    protected abstract List<String> getDotStrings();

    public final String[] getDotStringSkek() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.getDotStrings()) {
            if (!s.startsWith("nodesep") && !s.startsWith("ranksep")) continue;
            result.add(s);
        }
        String aspect = this.getPragma().getValue("aspect");
        if (aspect != null) {
            result.add("aspect=" + aspect + ";");
        }
        return result.toArray(new String[result.size()]);
    }

    private void createFilesXmi(OutputStream suggestedFile, FileFormat fileFormat) throws IOException {
        CucaDiagramXmiMaker maker = new CucaDiagramXmiMaker(this, fileFormat);
        maker.createFiles(suggestedFile);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            try {
                this.createFilesTxt(os, index, fileFormat);
            }
            catch (Throwable t) {
                t.printStackTrace(new PrintStream(os));
            }
            return new ImageDataSimple();
        }
        if (fileFormat.name().startsWith("XMI")) {
            this.createFilesXmi(os, fileFormat);
            return new ImageDataSimple();
        }
        if (this.getUmlDiagramType() == UmlDiagramType.COMPOSITE) {
            throw new UnsupportedOperationException();
        }
        CucaDiagramFileMakerSvek maker = new CucaDiagramFileMakerSvek(this);
        ImageData result = maker.createFile(os, this.getDotStrings(), fileFormatOption);
        if (result == null) {
            return new ImageDataSimple();
        }
        this.warningOrError = result.getWarningOrError();
        return result;
    }

    @Override
    public String getWarningOrError() {
        String generalWarningOrError = super.getWarningOrError();
        if (this.warningOrError == null) {
            return generalWarningOrError;
        }
        if (generalWarningOrError == null) {
            return this.warningOrError;
        }
        return generalWarningOrError + "\n" + this.warningOrError;
    }

    private void createFilesTxt(OutputStream os, int index, FileFormat fileFormat) throws IOException {
        CucaDiagramTxtMaker maker = new CucaDiagramTxtMaker(this, fileFormat);
        maker.createFiles(os, index);
    }

    public boolean isAutarkic(IGroup g) {
        if (g.getGroupType() == GroupType.PACKAGE) {
            return false;
        }
        if (g.getGroupType() == GroupType.INNER_ACTIVITY) {
            return true;
        }
        if (g.getGroupType() == GroupType.CONCURRENT_ACTIVITY) {
            return true;
        }
        if (g.getGroupType() == GroupType.CONCURRENT_STATE) {
            return true;
        }
        if (this.getChildrenGroups(g).size() > 0) {
            return false;
        }
        for (Link link : this.getLinks()) {
            if (EntityUtils.isPureInnerLink3(g, link)) continue;
            return false;
        }
        for (ILeaf leaf : g.getLeafsDirect()) {
            if (leaf.getEntityPosition() == EntityPosition.NORMAL) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumber(String s) {
        return s.matches("[+-]?(\\.?\\d+|\\d+\\.\\d*)");
    }

    public void resetPragmaLabel() {
        this.getPragma().undefine("labeldistance");
        this.getPragma().undefine("labelangle");
    }

    public String getLabeldistance() {
        String s;
        if (this.getPragma().isDefine("labeldistance") && CucaDiagram.isNumber(s = this.getPragma().getValue("labeldistance"))) {
            return s;
        }
        if (this.getPragma().isDefine("defaultlabeldistance") && CucaDiagram.isNumber(s = this.getPragma().getValue("defaultlabeldistance"))) {
            return s;
        }
        return "1.7";
    }

    public String getLabelangle() {
        String s;
        if (this.getPragma().isDefine("labelangle") && CucaDiagram.isNumber(s = this.getPragma().getValue("labelangle"))) {
            return s;
        }
        if (this.getPragma().isDefine("defaultlabelangle") && CucaDiagram.isNumber(s = this.getPragma().getValue("defaultlabelangle"))) {
            return s;
        }
        return "25";
    }

    @Override
    public final boolean isEmpty(IGroup gToTest) {
        for (IEntity iEntity : this.getGroups(false)) {
            if (iEntity == gToTest || iEntity.getParentContainer() != gToTest) continue;
            return false;
        }
        return gToTest.size() == 0;
    }

    public final boolean isVisibilityModifierPresent() {
        return this.visibilityModifierPresent;
    }

    public final void setVisibilityModifierPresent(boolean visibilityModifierPresent) {
        this.visibilityModifierPresent = visibilityModifierPresent;
    }

    @Override
    public final boolean showPortion(EntityPortion portion, IEntity entity) {
        if (this.getSkinParam().strictUmlStyle() && portion == EntityPortion.CIRCLED_CHARACTER) {
            return false;
        }
        boolean result = true;
        for (HideOrShow cmd : this.hideOrShows) {
            if (cmd.portion != portion || !cmd.gender.contains(entity)) continue;
            result = cmd.show;
        }
        return result;
    }

    public final void hideOrShow(EntityGender gender, Set<EntityPortion> portions, boolean show) {
        for (EntityPortion portion : portions) {
            this.hideOrShows.add(new HideOrShow(gender, portion, show));
        }
    }

    public void hideOrShow(Set<VisibilityModifier> visibilities, boolean show) {
        if (show) {
            this.hides.removeAll(visibilities);
        } else {
            this.hides.addAll(visibilities);
        }
    }

    public void hideOrShow(ILeaf leaf, boolean show) {
        leaf.setRemoved(!show);
    }

    public void hideOrShow(LeafType leafType, boolean show) {
        if (show) {
            this.hiddenType.remove((Object)leafType);
        } else {
            this.hiddenType.add(leafType);
        }
    }

    @Override
    public int getNbImages() {
        return this.horizontalPages * this.verticalPages;
    }

    public final Set<VisibilityModifier> getHides() {
        return Collections.unmodifiableSet(this.hides);
    }

    public ColorMapper getColorMapper() {
        return this.getSkinParam().getColorMapper();
    }

    public final boolean isStandalone(IEntity ent) {
        for (Link link : this.getLinks()) {
            if (link.getEntity1() != ent && link.getEntity2() != ent) continue;
            return false;
        }
        return true;
    }

    public final Link getLastLink() {
        List<Link> links = this.getLinks();
        for (int i = links.size() - 1; i >= 0; --i) {
            Link link = links.get(i);
            if (link.getEntity1().getEntityType() == LeafType.NOTE || link.getEntity2().getEntityType() == LeafType.NOTE) continue;
            return link;
        }
        return null;
    }

    public final ILeaf getLastEntity() {
        return this.lastEntity;
    }

    public final EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public void applySingleStrategy() {
        MagmaList magmaList = new MagmaList();
        for (IGroup g : this.getGroups(true)) {
            ArrayList<ILeaf> standalones = new ArrayList<ILeaf>();
            for (ILeaf ent : g.getLeafsDirect()) {
                if (!this.isStandalone(ent)) continue;
                standalones.add(ent);
            }
            if (standalones.size() < 3) continue;
            Magma magma = new Magma(this, standalones);
            magma.putInSquare();
            magmaList.add(magma);
        }
        for (IGroup g : this.getGroups(true)) {
            MagmaList magmas = magmaList.getMagmas(g);
            if (magmas.size() < 3) continue;
            magmas.putInSquare();
        }
    }

    public boolean isHideEmptyDescriptionForState() {
        return false;
    }

    protected void incRawLayout() {
        this.entityFactory.incRawLayout();
    }

    static class HideOrShow {
        private final EntityGender gender;
        private final EntityPortion portion;
        private final boolean show;

        public HideOrShow(EntityGender gender, EntityPortion portion, boolean show) {
            this.gender = gender;
            this.portion = portion;
            this.show = show;
        }
    }
}

