/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UFont;

public class PSystemCreole
extends AbstractPSystem {
    private final List<String> lines = new ArrayList<String>();

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Creole)", this.getClass());
    }

    public void doCommandLine(String line) {
        this.lines.add(line);
    }

    @Override
    public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        Display display = Display.create(this.lines);
        UFont font = new UFont("Serif", 0, 14);
        FontConfiguration fontConfiguration = FontConfiguration.blackBlueTrue(font);
        Sheet sheet = new CreoleParser(fontConfiguration, HorizontalAlignment.LEFT, null, CreoleMode.FULL).createSheet(display);
        SheetBlock1 sheetBlock = new SheetBlock1(sheet, 0.0, 0.0);
        ImageBuilder builder = new ImageBuilder(new ColorMapperIdentity(), 1.0, null, null, null, 0.0, 0.0, null, false);
        builder.addUDrawable(sheetBlock);
        return builder.writeImageTOBEMOVED(fileFormat, os);
    }
}

