/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.Sprite;

public class FtileFactoryDelegator
implements FtileFactory {
    private final FtileFactory factory;
    private final ISkinParam skinParam;
    private final Rose rose = new Rose();

    protected HtmlColor getInLinkRenderingColor(Ftile tile) {
        LinkRendering linkRendering = tile.getInLinkRendering();
        HtmlColor color = linkRendering == null || linkRendering.getColor() == null ? this.rose.getHtmlColor(this.getSkinParam(), ColorParam.activityArrow) : linkRendering.getColor();
        return color;
    }

    protected final TextBlock getTextBlock(Display display) {
        if (Display.isNull(display)) {
            return null;
        }
        ISkinParam skinParam = this.getSkinParam();
        FontConfiguration fontConfiguration = new FontConfiguration(skinParam, FontParam.ACTIVITY_ARROW, null);
        return display.create(fontConfiguration, HorizontalAlignment.LEFT, this, CreoleMode.SIMPLE_LINE);
    }

    protected Display getInLinkRenderingDisplay(Ftile tile) {
        LinkRendering linkRendering = tile.getInLinkRendering();
        if (linkRendering == null) {
            return Display.NULL;
        }
        return linkRendering.getDisplay();
    }

    public FtileFactoryDelegator(FtileFactory factory, ISkinParam skinParam) {
        this.factory = factory;
        this.skinParam = skinParam;
    }

    @Override
    public Ftile start(Swimlane swimlane) {
        return this.factory.start(swimlane);
    }

    @Override
    public Ftile end(Swimlane swimlane) {
        return this.factory.end(swimlane);
    }

    @Override
    public Ftile stop(Swimlane swimlane) {
        return this.factory.stop(swimlane);
    }

    @Override
    public Ftile activity(Display label, Swimlane swimlane, BoxStyle style, Colors colors) {
        return this.factory.activity(label, swimlane, style, colors);
    }

    @Override
    public Ftile addNote(Ftile ftile, Display note, NotePosition notePosition) {
        return this.factory.addNote(ftile, note, notePosition);
    }

    @Override
    public Ftile addUrl(Ftile ftile, Url url) {
        return this.factory.addUrl(ftile, url);
    }

    @Override
    public Ftile decorateIn(Ftile ftile, LinkRendering linkRendering) {
        return this.factory.decorateIn(ftile, linkRendering);
    }

    @Override
    public Ftile decorateOut(Ftile ftile, LinkRendering linkRendering) {
        return this.factory.decorateOut(ftile, linkRendering);
    }

    @Override
    public Ftile assembly(Ftile tile1, Ftile tile2) {
        return this.factory.assembly(tile1, tile2);
    }

    @Override
    public Ftile repeat(Swimlane swimlane, Ftile repeat, Display test, Display yes, Display out, HtmlColor color, LinkRendering backRepeatLinkRendering) {
        return this.factory.repeat(swimlane, repeat, test, yes, out, color, backRepeatLinkRendering);
    }

    @Override
    public Ftile createWhile(Swimlane swimlane, Ftile whileBlock, Display test, Display yes, Display out, LinkRendering afterEndwhile, HtmlColor color) {
        return this.factory.createWhile(swimlane, whileBlock, test, yes, out, afterEndwhile, color);
    }

    @Override
    public Ftile createIf(Swimlane swimlane, List<Branch> thens, Branch elseBranch, LinkRendering afterEndwhile, LinkRendering topInlinkRendering) {
        return this.factory.createIf(swimlane, thens, elseBranch, afterEndwhile, topInlinkRendering);
    }

    @Override
    public Ftile createFork(Swimlane swimlane, List<Ftile> all) {
        return this.factory.createFork(swimlane, all);
    }

    @Override
    public Ftile createSplit(List<Ftile> all) {
        return this.factory.createSplit(all);
    }

    @Override
    public Ftile createGroup(Ftile list, Display name, HtmlColor backColor, HtmlColor titleColor, Display headerNote, HtmlColor borderColor) {
        return this.factory.createGroup(list, name, backColor, titleColor, headerNote, borderColor);
    }

    @Override
    public StringBounder getStringBounder() {
        return this.factory.getStringBounder();
    }

    protected final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    protected final Rose getRose() {
        return this.rose;
    }

    @Override
    public boolean shadowing() {
        return this.skinParam.shadowing();
    }

    protected FtileFactory getFactory() {
        return this.factory;
    }

    @Override
    public Sprite getSprite(String name) {
        return this.skinParam.getSprite(name);
    }

    @Override
    public String getValue(String key) {
        return this.skinParam.getValue(key);
    }

    @Override
    public double getPadding() {
        return this.skinParam.getPadding();
    }

    @Override
    public boolean useGuillemet() {
        return this.skinParam.useGuillemet();
    }

    @Override
    public String getMonospacedFamily() {
        return this.skinParam.getMonospacedFamily();
    }

    @Override
    public int getTabSize() {
        return this.skinParam.getTabSize();
    }
}

