/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;

public class CommandActivity3
extends SingleLineCommand2<ActivityDiagram3> {
    public static final String ENDING_GROUP = "(;|(?<![/|<>}\\]])(?:[/<}\\]])|(?<!\\</?\\w{1,5})(?<!\\<img[^>]{1,999})(?<!\\<\\$\\w{1,999})(?<!\\>)(?:\\>)|(?<!\\|.{1,999})(?:\\|))";

    public CommandActivity3() {
        super(CommandActivity3.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), CommandActivity3.color().getRegex(), new RegexLeaf("[%s]*"), new RegexLeaf(":"), new RegexLeaf("LABEL", "(.*)"), new RegexLeaf("STYLE", ENDING_GROUP), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, RegexResult arg) {
        Url url;
        if (arg.get("URL", 0) == null) {
            url = null;
        } else {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            url = urlBuilder.getUrl(arg.get("URL", 0));
        }
        Colors colors = CommandActivity3.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        BoxStyle style = BoxStyle.fromChar(arg.get("STYLE", 0).charAt(0));
        diagram.addActivity(Display.getWithNewlines(arg.get("LABEL", 0)), style, url, colors);
        return CommandExecutionResult.ok();
    }
}

