/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.html5.UGraphicHtml5;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.tikz.UGraphicTikz;
import net.sourceforge.plantuml.ugraphic.visio.UGraphicVdx;

public class FileFormatOption
implements Serializable {
    private final FileFormat fileFormat;
    private final AffineTransform affineTransform;
    private final boolean withMetadata;
    private final boolean useRedForError;
    private final String svgLinkTarget;

    public FileFormatOption(FileFormat fileFormat) {
        this(fileFormat, null, true, false, "_top");
    }

    public String getSvgLinkTarget() {
        return this.svgLinkTarget;
    }

    public final boolean isWithMetadata() {
        return this.withMetadata;
    }

    public FileFormatOption(FileFormat fileFormat, boolean withMetadata) {
        this(fileFormat, null, false, false, "_top");
    }

    private FileFormatOption(FileFormat fileFormat, AffineTransform at, boolean withMetadata, boolean useRedForError, String svgLinkTarget) {
        this.fileFormat = fileFormat;
        this.affineTransform = at;
        this.withMetadata = withMetadata;
        this.useRedForError = useRedForError;
        this.svgLinkTarget = svgLinkTarget;
    }

    public FileFormatOption withUseRedForError() {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, true, this.svgLinkTarget);
    }

    public FileFormatOption withSvgLinkTarget(String target) {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, this.useRedForError, target);
    }

    public String toString() {
        return this.fileFormat.toString() + " " + this.affineTransform;
    }

    public final FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public UGraphic2 createUGraphic(ColorMapper colorMapper, double dpiFactor, Dimension2D dim, HtmlColor mybackcolor, boolean rotation) {
        switch (this.fileFormat) {
            case PNG: {
                return this.createUGraphicPNG(colorMapper, dpiFactor, dim, mybackcolor, rotation);
            }
            case SVG: {
                return this.createUGraphicSVG(colorMapper, dpiFactor, dim, mybackcolor, rotation);
            }
            case EPS: {
                return new UGraphicEps(colorMapper, EpsStrategy.getDefault2());
            }
            case EPS_TEXT: {
                return new UGraphicEps(colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            }
            case HTML5: {
                return new UGraphicHtml5(colorMapper);
            }
            case VDX: {
                return new UGraphicVdx(colorMapper);
            }
            case LATEX: {
                return new UGraphicTikz(colorMapper);
            }
        }
        throw new UnsupportedOperationException(this.fileFormat.toString());
    }

    public UGraphic2 createUGraphic(Dimension2D dim) {
        return this.createUGraphic(new ColorMapperIdentity(), 1.0, dim, null, false);
    }

    private UGraphic2 createUGraphicSVG(ColorMapper colorMapper, double scale, Dimension2D dim, HtmlColor mybackcolor, boolean rotation) {
        Color backColor = Color.WHITE;
        if (mybackcolor instanceof HtmlColorSimple) {
            backColor = colorMapper.getMappedColor(mybackcolor);
        }
        UGraphicSvg ug = mybackcolor instanceof HtmlColorGradient ? new UGraphicSvg(colorMapper, (HtmlColorGradient)mybackcolor, false, scale, this.getSvgLinkTarget()) : (backColor == null || backColor.equals(Color.WHITE) ? new UGraphicSvg(colorMapper, false, scale, this.getSvgLinkTarget()) : new UGraphicSvg(colorMapper, StringUtils.getAsHtml(backColor), false, scale, this.getSvgLinkTarget()));
        return ug;
    }

    private UGraphic2 createUGraphicPNG(ColorMapper colorMapper, double dpiFactor, Dimension2D dim, HtmlColor mybackcolor, boolean rotation) {
        Graphics2D graphics2D;
        EmptyImageBuilder builder;
        Color backColor = Color.WHITE;
        if (mybackcolor instanceof HtmlColorSimple) {
            backColor = colorMapper.getMappedColor(mybackcolor);
        } else if (mybackcolor instanceof HtmlColorTransparent) {
            backColor = null;
        }
        if (rotation) {
            builder = new EmptyImageBuilder((int)(dim.getHeight() * dpiFactor), (int)(dim.getWidth() * dpiFactor), backColor);
            graphics2D = builder.getGraphics2D();
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.translate(-builder.getBufferedImage().getHeight(), 0);
        } else {
            builder = new EmptyImageBuilder((int)(dim.getWidth() * dpiFactor), (int)(dim.getHeight() * dpiFactor), backColor);
            graphics2D = builder.getGraphics2D();
        }
        UGraphicG2d ug = new UGraphicG2d(colorMapper, graphics2D, dpiFactor);
        ug.setBufferedImage(builder.getBufferedImage());
        BufferedImage im = ug.getBufferedImage();
        if (mybackcolor instanceof HtmlColorGradient) {
            ug.apply(new UChangeBackColor(mybackcolor)).draw(new URectangle(im.getWidth(), im.getHeight()));
        }
        return ug;
    }

    public final boolean isUseRedForError() {
        return this.useRedForError;
    }
}

