#include <ges/ges.h>

 GESTimeline *timeline;
 GESPipeline *pipeline;
 GstBus* bus;

 static void smMessageCb(GstBus* pBusPtr, GstMessage* pMsgPtr)
 {

    switch (GST_MESSAGE_TYPE (pMsgPtr)) 
    {
        case GST_MESSAGE_EOS:
        {
            g_message ("got EOS");
            break;
        }
        case GST_MESSAGE_STATE_CHANGED:
        {
            //Add these lines to see states of every element.
           // GstState old_state, new_state;
           // gst_message_parse_state_changed(pMsgPtr, &old_state, &new_state, NULL);
           // g_message ("Element %s changed state from %s to %s.",GST_OBJECT_NAME(pMsgPtr->src), gst_element_state_get_name(old_state), gst_element_state_get_name(new_state));
            break;
        }
        case GST_MESSAGE_WARNING:
        {
            GError *gerror;
            gchar *debug;

            gst_message_parse_warning (pMsgPtr, &gerror, &debug);
            gst_object_default_error (GST_MESSAGE_SRC (pMsgPtr), gerror, debug);
            g_error_free (gerror);
            g_free (debug);
            break;
        }
        case GST_MESSAGE_ERROR:
        {
            GError *gerror;
            gchar *debug;

            gst_message_parse_error (pMsgPtr, &gerror, &debug);
            gst_object_default_error (GST_MESSAGE_SRC (pMsgPtr), gerror, debug);
            g_error_free (gerror);
            g_free (debug);
            break;
        }
        default:
            break;
    }
 }

gboolean callback(gpointer data)
{
    gint64 pos;
    GstEvent*   lSeekVideoEvent = NULL;
     gst_element_query_position (GST_ELEMENT(pipeline), GST_FORMAT_TIME, &pos);
   lSeekVideoEvent= gst_event_new_seek(-1.0, GST_FORMAT_TIME,
        (GstSeekFlags)(GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_ACCURATE),
        GST_SEEK_TYPE_SET, 0,
        GST_SEEK_TYPE_SET, pos);
    gst_element_send_event(GST_ELEMENT(pipeline), lSeekVideoEvent);

    // Add a trace to see what is the current position after the stepping.
    g_message ("Reverse at %" GST_TIME_FORMAT, GST_TIME_ARGS (pos));

    return FALSE;
}

int main (int argc, char **argv)
{
    GESLayer *layer_video;
    GESTrack *trackv;
    GMainLoop *mainloop;

    if (argc == 1) 
    {
      g_printerr ("Usage: play_timeline_with_one_clip file:///clip/uri\n");
      return 1;
    }

    gst_init (NULL, NULL);
    ges_init ();

    timeline = ges_timeline_new ();

    trackv = GES_TRACK (ges_video_track_new ());

    layer_video = ges_timeline_append_layer(timeline);

    if (!ges_timeline_add_track (timeline, trackv))
        return -1;

    { 
        /* Add a clip with a duration of 120 seconds */
        const gchar* uri = argv[1];
        GESAsset* asset = GES_ASSET (ges_uri_clip_asset_request_sync (uri, NULL));
        ges_layer_add_asset (layer_video, asset, 0, 0,120*GST_SECOND, GES_TRACK_TYPE_VIDEO);
    }

    ges_timeline_commit_sync (timeline);



    pipeline = ges_pipeline_new ();
    bus = gst_pipeline_get_bus (GST_PIPELINE (pipeline));

    // Connecting the bus to a callback
    gst_bus_add_signal_watch(bus);
    gst_bus_set_sync_handler (bus, gst_bus_sync_signal_handler, NULL,NULL);
    g_signal_connect(bus, "sync-message", G_CALLBACK(smMessageCb), NULL);

    ges_pipeline_set_timeline (pipeline, timeline);
    gst_element_set_state (GST_ELEMENT (pipeline), GST_STATE_PLAYING);

    mainloop = g_main_loop_new (NULL, FALSE);

    g_timeout_add_seconds (10, (GSourceFunc) callback,mainloop); // stepping after 10 seconds
    g_timeout_add_seconds (120, (GSourceFunc) g_main_loop_quit,mainloop); // EOS

    g_main_loop_run (mainloop);

    // Freeing elements
    gst_element_set_state (GST_ELEMENT (pipeline), GST_STATE_NULL);
    gst_bus_remove_watch(bus);
    gst_object_unref (bus);
    gst_object_unref (pipeline);

    return 0;
}
