/*!
 *  @file
 *  @brief Doxygen test case for REFERENCES_RELATION.
 *
 *  Doxygen 1.8.11 fails this test case.
 *
 *  @author Tomasz Mon <desowin@gmail.com>
 */

/*!
 *  @defgroup REFERENCES_RELATION_TEST REFERENCES_RELATION check
 *  Doxygen REFERENCES_RELATION list test case.
 *
 *  This example shows that References for one function can inherit
 *  References from subsequent non documented function.
 *  If get_undocumented_struct() gets documented the problem disappears.
 *
 *  After generating documentation in Function Documentation for get_int()
 *  there will be:
<PRE>
static int* get_int (MY_ENUM e)

Gets integer for MY_ENUM. 

Parameters

  e MY_ENUM for which the integer should be returned.

Returns
  Pointer to integer corrensponding to provided MY_ENUM.
  NULL if there is no matching integer. 

Definition at line 86 of file doxygen_references_test.c.

References ARRAY_ELEMENTS, E_ONE, E_TWO, iUndocumentedFour, iUndocumentedOne, iUndocumentedThree, iUndocumentedTwo, UndocumentedStruct::one.
</PRE>
 *  If you look at the code iUndocumentedOne, iUndocumentedTwo, iUndocumentedThree, iUndocumentedFour nor UndocumentedStruct
 *  are not being referenced by get_int().
 *  @{
 */

/*! My enum */
typedef enum
{
   E_ONE,   /**< One. */
   E_TWO,   /**< Two. */
}
MY_ENUM;

/*! Integer for E_ONE. */
static int iOne;
/*! Integer for E_TWO. */
static int iTwo;

/*! Structure returned by undocumented function. */
typedef struct
{
    int *one;   /**< One. */
    int *two;   /**< Two. */
    int *three; /**< Three. */
    int *four;  /**< Four. */
}
UndocumentedStruct;

/*! Variable used only in undocumented function. */
static int iUndocumentedOne;
/*! Variable used only in undocumented function. */
static int iUndocumentedTwo;
/*! Variable used only in undocumented function. */
static int iUndocumentedThree;
/*! Variable used only in undocumented function. */
static int iUndocumentedFour;

/*! Gets number of elements in static array. */
#define ARRAY_ELEMENTS(array) (sizeof(array)/sizeof(array[0]))


/*!
 *  @brief Gets integer for MY_ENUM.
 *
 *  @param e MY_ENUM for which the integer should be returned.
 *
 *  @return Pointer to integer corrensponding to provided MY_ENUM.
 *  @return NULL if there is no matching integer.
 */
static int *get_int(MY_ENUM e)
{
    switch (e)
    {
        case E_ONE:   return &iOne;
        case E_TWO:   return &iTwo;
        default:      return NULL;
    }
}

static const UndocumentedStruct *get_undocumented_struct(MY_ENUM e)
{
    static const UndocumentedStruct set[] =
    {
        [E_ONE] =
        {
            .one = &iUndocumentedOne,
            .two = &iUndocumentedTwo,
            .three = &iUndocumentedThree,
            .four = &iUndocumentedFour,
        }
    };

    if ((e >= 0) && (e < ARRAY_ELEMENTS(set))
    {
        return &set[e];
    }
    return NULL;
}

/* @} */ /* End of group REFLIST_TEST */
