/// \file
/// Set of accelerations
///
/// Compiles with "g++ -c -Wall -pedantic -std=c++11 -g3 -O0 bar.cpp -o bar.o"

#include <cstdint>		// uint8_t

/// Container

class T
{
public:
  /// Base class
  class B
  {
  public:
    B (std::uint8_t (&)[25]);
    std::uint8_t (&a_)[25];	///< ref to array here
  };
  /// Derived class
  class D:public B
  {
  public:
    D (std::uint8_t (&)[25]);
    D (B);
  };
};

/// Construct baseclass
///
/// \param a State

T::B::B (std::uint8_t (&a)[25]):a_ (a)
{
}

/// Construct a derived class
///
/// \param a State

T::D::D (std::uint8_t (&a)[25]):B (a)
{
}

/// Copy internal states from baseclass
///
/// \param b Baseclass object

T::D::D (B b):B (b)
{
}
