#include <gtk/gtk.h>

#if GTK_CHECK_VERSION(3,0,0)
#include <gtk/gtkx.h>
#endif 


int main (int argc, char **argv)
{
	GtkWidget *window;
	GtkWidget *socket;
	GdkScreen *screen;
	gint32 socket_id;
	gchar  *cmd[3];
	
	gtk_init(&argc, &argv);

	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
     
    gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
	gtk_window_set_default_size(GTK_WINDOW(window),320,200);
	
	socket = gtk_socket_new ();
	gtk_container_add(GTK_CONTAINER(window), socket);

	screen = gtk_window_get_screen(GTK_WINDOW(window));
	socket_id = gtk_socket_get_id (GTK_SOCKET(socket));

	gtk_widget_show_all(window);  
	g_signal_connect (window, "delete-event", G_CALLBACK (gtk_main_quit), NULL);
	
	/* Spawn the plug app */
#if GTK_CHECK_VERSION(3,0,0)
	cmd[0] = (gchar *) "./plug-gtk3";
#else
	cmd[0] = (gchar *) "./plug-gtk2";
#endif

	cmd[1] = g_strdup_printf("--socket-id=%d", socket_id);
	cmd[2] = NULL;
	
#if GTK_CHECK_VERSION(3,0,0)
	if (!g_spawn_async (NULL, cmd, NULL, G_SPAWN_SEARCH_PATH, 0, NULL, NULL, NULL))
	{
		g_error ("Error ** spawning the plug app\n");
	}
#else
	if (!gdk_spawn_on_screen (screen, NULL, cmd, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL))
	{
		g_error ("Error * spawning the plug app--------\n");
	}
#endif	
	
	gtk_main();
	return 0;
}

