/** 
 * @addtogroup bar
 * @{
 */
/**************************************************************************//**
 * @file      bar.h
 * @author    Jeronimo Werder
 * @date      2013-10-15
 *
 * @copyright Copyright 2013 Plexus, Inc.
 *
 * @brief     Doxygen H-file Example at the example of bar.h.
 *
 * @details   This file contains an example for the usage of Doxygen. In this 
 *            case it would be the detailed description of the file bar.h.    
 *
 ******************************************************************************/
 
#ifndef _BAR_H_
#define _BAR_H_

/* ---------- Typdefs and Defines ------------------------------------------- */

#define PI 3.1415926 /**< definition of the constant number Pi */

/**
 * Returns the maximum of the two numbers a and b.
 * 
 * @param a    The first of the two values which shall be compared
 * @param b    The second of the two values which shall be compared
 *
 * @return The maximum of the two values
 */
#define max(a,b) \
  ({ __typeof__ (a) _a = (a); \
     __typeof__ (b) _b = (b); \
      _a > _b ? _a : _b; })



/* ---------- Function Declarations ----------------------------------------- */

void bar(int a, int b);

#endif /* _BAR_H_ */
/**
 * @}
 */
