::=============================================================================
::  CreateDocumentation.bat
:: -------------------------
:: This file invokes Doxygen to generate the documentation from the 
:: Project and creates a PDF file from the generated LaTex files.
:: The Batch file defines the Document Title, Document Number, determines
:: the Revise Date and asks the user for the Revision Letter and if the 
:: document is a draft version. If it's not a draft version the user has
:: to type in a Revision History Comment. The script generates then a
:: Revision History Table which is added to the document.
::=============================================================================
@echo off

::-------------------------------------------------------
:: Define the absolute path to doxygen
::-------------------------------------------------------
set DOXYGEN_APP_PATH="C:\Program Files\doxygen-1.8.10\bin\doxygen"

::-------------------------------------------------------
:: Define relative path to the Doxygen Configuration File
::-------------------------------------------------------
set DOXYFILE_PATH=.\config\Doxyfile

::-------------------------------------------------------
:: Define the relative path to the Latex output folder
::-------------------------------------------------------
set LATEX_OUTPUT_PATH=.\output\latex\

::-------------------------------------------------------
:: Define the relative path to the Latex templates folder
::-------------------------------------------------------
set LATEX_TEMPLATES_PATH=.\templates\latex\

::-------------------------------------------------------
:: Define the relative path to the general dox folder
::-------------------------------------------------------
set DOX_PATH=.\dox\

::-------------------------------------------------------
:: Define document title
::-------------------------------------------------------
call :GETVALUEOF PROJECT_NAME %DOXYFILE_PATH%
set PROJECT_TITLE=%GETVALUEOF_RETVAL%
set DOCTITLE=%PROJECT_TITLE% SDD

::-------------------------------------------------------
:: Define document sub-title
::-------------------------------------------------------
call :GETVALUEOF PROJECT_BRIEF %DOXYFILE_PATH%
set SUBTITLE=%GETVALUEOF_RETVAL%

::-------------------------------------------------------
:: Define Document ID
::-------------------------------------------------------
set DOCNUMBER=Dxxxxx

::-------------------------------------------------------
:: Define Customer Name
::-------------------------------------------------------
set CUSTOMERNAME=Customer Name




::-----------------------------------------------------------------------------
:: Get current date
::-----------------------------------------------------------------------------
:: for /f "tokens=1-4 delims=/ " %%a in ("%date%") do set /a month = 1%%a - 100
:: for /f "tokens=%month%" %%a in (
:: 'echo Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec'
:: ) do set MONTH=%%a
:: set REVDATE=%date:~3,2% %MONTH% %date:~6,4%
for /f %%i in ('.\doctools\GetDate') do set REVDATE=%%i

::-----------------------------------------------------------------------------
:: Run Doxygen
::-----------------------------------------------------------------------------
echo -------------------------------------------------------------------------------
echo.
echo  Run Doxygen
echo.
echo -------------------------------------------------------------------------------
%DOXYGEN_APP_PATH% %DOXYFILE_PATH%

::-----------------------------------------------------------------------------
:: Customize Frontpage, Page Header & Footer
::-----------------------------------------------------------------------------
echo -------------------------------------------------------------------------------
echo.
echo  Enter necessary data
echo.
echo -------------------------------------------------------------------------------
pushd %LATEX_OUTPUT_PATH%
echo %DOCTITLE% > title.tex
echo %SUBTITLE% > subtitle.tex
echo %DOCNUMBER% > docid.tex
echo %REVDATE% > revdate.tex
echo %CUSTOMERNAME% > customername.tex
popd
:: Create Revision History File if not exists
pushd %DOX_PATH%
if not exist revhistory.tex (
echo %% This is a generated file > revhistory.tex
echo %% DO NOT DELETE THIS FILE! >> revhistory.tex
echo.
echo.
)
popd
:: Ask for the revision letter of the document 
echo.
set /p RevisionLetter="Enter the Revision Letter of this document: "

:: Ask if the document shall be marked as "draft"
echo.
choice /c yn /n /m "Shall this document be marked as a draft? (Y/N): "
if %errorlevel% == 1 goto IS_DRAFT
if %errorlevel% == 2 goto IS_RELEASE

:IS_DRAFT
set IsDraft=true
pushd %LATEX_OUTPUT_PATH%
:: Add Watermark to Document
echo \usepackage{draftwatermark} > isdraft.tex
:: Add revision letter with DRAFT hint to the document
echo DRAFT %RevisionLetter%> revisionletter.tex
popd
GOTO BRANCH_END

:IS_RELEASE
set IsDraft=false
pushd %LATEX_OUTPUT_PATH%
:: Remove Watermark from Document
echo. > isdraft.tex
:: Add revision letter to the document
echo %RevisionLetter% > revisionletter.tex
popd

:: Enter Revision History Comment
echo.
:ENTER_REVISION_COMMENT
pushd %DOX_PATH%
set /p RevisionHistoryComment="Enter a comment for the Revision History: "
if "%RevisionHistoryComment%" == "" goto NO_REVISION_COMMENT
echo %RevisionLetter% ^& %REVDATE% ^& %RevisionHistoryComment% \\ >> revhistory.tex
echo \hline >> revhistory.tex
popd
goto BRANCH_END
:NO_REVISION_COMMENT
echo.
echo In a non-draft document you have to enter a comment for the Revision History!
goto ENTER_REVISION_COMMENT

:BRANCH_END

::-----------------------------------------------------------------------------
:: Copy the necessary files to the latex folder
::-----------------------------------------------------------------------------
:: suppress question if it is a file or directory
echo f > answer.tmp 
:: Copy the files
xcopy %LATEX_TEMPLATES_PATH%PlexusDoxygen.sty %LATEX_OUTPUT_PATH%doxygen.sty /Y < answer.tmp
xcopy %DOX_PATH%revhistory.tex %LATEX_OUTPUT_PATH%revhistory.tex /Y < answer.tmp

::-----------------------------------------------------------------------------
:: Generate PDF file
::-----------------------------------------------------------------------------
pushd %LATEX_OUTPUT_PATH%
call make.bat
popd

::-----------------------------------------------------------------------------
:: Copy and Rename PDF file
::-----------------------------------------------------------------------------
echo -------------------------------------------------------------------------------
echo.
echo  Copy and rename PDF the generated PDF file
echo.
echo -------------------------------------------------------------------------------
::----------------------------------------------
:: Release Version of the Document is added to 
:: the document name with the suffix _REV_x
::----------------------------------------------
set DOCTITLE=%DOCTITLE: =_%
if "%IsDraft%" == "false" (
    xcopy %LATEX_OUTPUT_PATH%refman.pdf .\%DOCNUMBER%_%DOCTITLE%_Rev_%RevisionLetter%.pdf /Y < answer.tmp)
:: Draft Version of the Document is marked with the suffix _DRAFT_x
if not "%IsDraft%" == "false" (
    xcopy %LATEX_OUTPUT_PATH%refman.pdf .\%DOCNUMBER%_%DOCTITLE%_Draft_%RevisionLetter%.pdf /Y < answer.tmp)

:: Delete temporary files
del answer.tmp
echo _%PROJECT_TITLE%_
:: Quit Processing
goto END_OF_FILE


::=============================================================================
:: Subroutines
::=============================================================================

::-------------------------------------------------------------------
:: Subroutine GETVALUEOF <Config Option> <Config File Name>
:: This subroutine searches for the given Configuration Option
:: in the given Doxygen Config File and returns the value of it.
::-------------------------------------------------------------------
:GETVALUEOF
::----------------------------------------------
:: Find string
::----------------------------------------------
for /f "delims=" %%a in ('findstr /B "%1" "%2"') do set GETVALUEOF_RETVAL=%%a
::----------------------------------------------
:: Remove Config Tag
::----------------------------------------------
set GETVALUEOF_RETVAL=%GETVALUEOF_RETVAL:PROJECT_NAME=%
::----------------------------------------------
:: Remove leading spaces
::----------------------------------------------
for /f "tokens=* delims= " %%a in (%GETVALUEOF_RETVAL%) do set GETVALUEOF_RETVAL=%%a
::----------------------------------------------
:: Remove "= " character
::----------------------------------------------
for /f "tokens=* delims== " %%a in (%GETVALUEOF_RETVAL%) do set GETVALUEOF_RETVAL=%%a
::----------------------------------------------
:: Return String
::----------------------------------------------
exit /b %GETVALUEOF_RETVAL%

::=============================================================================
:: End of File
::=============================================================================
:END_OF_FILE
@echo on
pause