/** 
 * @addtogroup foo
 * @{
 */

/**************************************************************************//**
 * @file      foo.c
 * @author    Jeronimo Werder
 * @date      2013-10-15
 *
 * @copyright &copy Plexus Inc. 2013 - 2015 
 *            Plexus Deutschland GmbH
 *            Bratustrasse 7
 *            D-64293 Darmstadt
 *
 * @brief     Doxygen C-file Example at the example of foo.c.
 *
 * @details   This file contains an example for the usage of Doxygen. This is
 *            the detailed description for the whole file foo. 
 ******************************************************************************/

#include "foo.h"
 
/* ---------- Global Variables ---------------------------------------------- */
 
int GlobalVar = 0; /**< This is a global variable */

/* ---------- Function Definitions ------------------------------------------ */
 
/**
 * @brief     A brief description of the function foo.
 *            
 * @details   This function does nothing. You can tell here more details about
 *            doing nothing and give an detailed description how to do nothing.
 *            This text shall only show how your documentation is looking like
 *            and so it is not necessary for this function to do anything.
 *            
 *            This is a new paragraph which also tells you nothing, because the
 *            only intention of this paragraph is only to show how such a 
 *            paragraph might look like.
 *
 * @attention This text shall only show you, how such a \"attention\" section
 *            is looking. There is nothing which really needs your attention,
 *            so you do not really need to read this section.
 *
 *            Further you can add some example code:
 *
 * @code{.c}
 *
 *     void main(void)
 *     {
 *         // This demonstartes the usage of foo()
 *         int var = foo(5u, 10u);
 *     }
 *
 * @endcode 
 *
 * @param     a    Description of parameter a.
 * @param     b    Description of parameter b.
 *
 * @return    Returns any sensless value. 
 */
int foo(int a, int b)
{
    return 45;
}

/**
 * @}
 */
