/** 
 * @addtogroup bar
 * @{
 */
/**************************************************************************//**
 * @file      bar.c
 * @author    Jeronimo Werder
 * @date      2013-10-15
 *
 * @copyright Copyright 2013 Plexus, Inc.
 *
 * @brief     Doxygen C-file Example.
 * @details   This file contains an example for the usage of Doxygen. In this 
 *            case it is the detailed description of the file bar.c.   
 *
 ******************************************************************************/
 
#include "bar.h"
 
/**
 * @brief   The function bar.
 *
 * @details This function does something which is doing nothing. So this text
 *          is totally senseless and you really do not need to read this,
 *          because this text is basically saying nothing.
 *
 * @note    This text shall only show you, how such a \"note\" section
 *          is looking. There is nothing which really needs your notice,
 *          so you do not really need to read this section.
 *
 * @param   a    Description of parameter a.
 * @param   b    Description of parameter b.
 *
 * @retval  None 
 */
void bar(int a, int b)
{
    /** More description inside the code */
}

/** 
 * @addtogroup subbar_1
 * @{
 */
/**
 * @brief   Function of submodule @ref subbar_1
 *
 * @details This text shall show you how to create a table in your
 *          detailed description:
 *          | First Column | Second Column | Third Column |
 *          |--------------|---------------|--------------|
 *          | First Line   | First Line    | First Line   |
 *          | Second Line  | Second Line   | Second Line  |
 */
void subbar1()
{
}
/**
 * @}
 */
 
/** 
 * @addtogroup subbar_2
 * @{
 */
/**
 * @brief     Function of submodule @ref subbar_2
 *            
 * @details   Also this text is saying nothing and shall only
 *            show you how to reference another function, for
 *            example the function \ref bar().
 *     
 * @remark    This Text shall only show you how such a \"remark\" section
 *            will look like.
 *
 *            Some dummy text between the \"Remarks\" and the \"Note\" 
 *            section...
 * 
 * @note      This text shall only show you, how such a \"note\" section
 *            will look like. The only purpose of this note is to give you the
 *            chance to compare the output differences of \@note, \@attention 
 *            and \@warning.
 *
 *            Some dummy text between the \"Note\" and the \"Attention\" 
 *            section...
 *
 * @attention This text shall only show you, how such a \"attention\" section
 *            will look like. The only purpose of this section is to give you 
 *            the chance to compare the output differences of \@note,  
 *            \@attention and \@warning
 *
 *            ... and more dummy text between the \"Attention\" and the 
 *            \"Warning\" section...
 * 
 * @warning   This text shall only show you how a \"warning\" section will look 
 *            like. This might help you to decide which type of special comment  
 *            you want to use: \@note, \@attention or \@warning.
 */
void subbar2()
{
}
/**
 * @}
 */

/**
 * @}
 */