/** 
 * @addtogroup foo
 * @{
 */
/**************************************************************************//**
 * @file      foo.h
 * @author    Jeronimo Werder
 * @date      2013-10-15
 *
 * @copyright Copyright 2013 Plexus, Inc.
 *
 * @brief     Doxygen H-file Example.
 * @details   This file contains an example for the usage of Doxygen.    
 *
 ******************************************************************************/
#ifndef _FOO_H_
#define _FOO_H_

/* ---------- Typdefs and Defines ------------------------------------------- */

/**
 * Unsigned 8-bit type.
 */
typedef unsigned char uint8_t; 

/**
 * @brief   Enumeration representing colors.
 *
 * @details A more detailed description.
 */
typedef enum
{
    RED = 0, /**< Represents red */
	GREEN,   /**< Reperesents green */
	BLUE     /**< Represents blue */
} colors_t;

/**
 * @brief   Brief description of this structure.
 *
 * @details A more detailed description.
 */
struct Structure_s
{
    int firstStructMember;  /**< Description of firstStructMember */
	int secondStructMember; /**< Description of secondStructMember */
};
/**
 * @brief type name referencing the struct @ref Structure_s
 */
typedef struct Structure_s structure_t;

/**
 * @brief Structure Type representing a coordinate
 */
typedef struct
{
    int x; /**< X-Coordinate */
	int y; /**< Y-Coordinate */
} coordinates_t;

/* ---------- Global Variables ---------------------------------------------- */

extern int GlobalVar;

/* ---------- Function Declarations ----------------------------------------- */
 
int foo(int a, int b);

#endif /* _FOO_H_ */
/**
 * @}
 */