#!/usr/bin/perl -w

###############################################################################
# File:        removeAuthorSection.pl
#
# Author:      Jeronimo Werder
#
# Date:        27-AUG-2015
#
# Description: This script written for the use with Doxygen to filter out the
#              author section of the source file header comments. Doxygen 
#              supports no possibility to suppress the contents of the tags 
#              @author, @date and @copyright from the file documentation.
#
#              This script may be used with the Doxygen option "INPUT_FILTER"
#              to filter out these tags, so that these informations are not
#              included in the file documentation generated by Doxygen.
###############################################################################

while(<>)
{
    if(($_ =~ /[\@\\]author/) || 
       ($_ =~ /[\@\\]date/) || 
       ($_ =~ /[\@\\]copyright/))
    {
        # Replace this line with an empty comment line.
        print STDOUT "*\n";
        
        # Also replace all following lines until the next doxygen tag is occuring
        while(<>)
        {
            # Check if the next line does not contain a doxygen tag
            if((($_ !~ /[\@\\]/) &&
                ($_ !~ /\*\//)) || 
               ($_ =~ /[\@\\]author/) ||
               ($_ =~ /[\@\\]date/) ||
               ($_ =~ /[\@\\]copyright/))
            {
                # It's one of the doxygen tags to filter out or a follow-up line
                # so replace this line with an empty comment line.
                print STDOUT "*\n";
            }
            else
            {
                # This line contains a doxygen tag, so print out this line.
                print STDOUT $_;
                last;
            }
        }
    }
    else
    {
      print STDOUT $_;
    }
}
