/* gfileutf8.h - UTF-8 wrappers for C library functions
 *
 * Copyright 2004 Tor Lillqvist
 *
 * GLib is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * GLib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GLib; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __G_FILEUTF8_H__
#define __G_FILEUTF8_H__

#include <gfileutils.h>

#include <stdio.h>
#include <sys/stat.h>

/* Wrappers for C library functions that take UTF-8 filenames. On
 * Unix, where there is just the "char" C API, the UTF-8 arguments are
 * simply converted from UTF-8 to the filename encoding as in
 * g_filename_from_utf8(). On Windows, they call the wide-character
 * versions of the C library functions.
 */

int g_open_utf8      (const gchar *pathname_utf8,
		      int          flags,
		      int          mode);
		     
int g_rename_utf8    (const gchar *oldpath_utf8,
		      const gchar *newpath_utf8);
		     
		     
int g_mkdir_utf8     (const gchar *pathname_utf8,
		      int          mode);
		     
int g_stat_utf8      (const gchar *pathname_utf8,
		      struct stat *buf);
		     
int g_unlink_utf8    (const gchar *pathname_utf8);
		     
FILE *g_fopen_utf8   (const gchar *pathname_utf8,
		      const gchar *mode_utf8);

FILE *g_freopen_utf8 (const gchar *pathname_utf8,
		      const gchar *mode_utf8,
		      FILE        *stream);

#endif /* __G_FILEUTF8_H__ */
