package at.doxygen.bug.annotations;

/**
 * This is a documented class without any annotations.
 * <p>
 * Doxygen produces no documentation at all.<br>
 * <br>
 * Public methods in this class:
 * <ul>
 * <li>{@link #AnnotatedWithSuppressWarnings()}</li>
 * <li>{@link #toLowerCaseString(CharSequence)}</li>
 * </p>
 * 
 * @author starfury
 */
@SuppressWarnings("javadoc")
public class AnnotatedWithSuppressWarnings {

	/**
	 * This is the default constructor.
	 */
	public AnnotatedWithSuppressWarnings() {
		// does nothing
	}

	public String toLowerCaseString(CharSequence someText) {
		return someText.toString().toLowerCase();
	}

}