package at.doxygen.bug.annotations;

/**
 * This is a documented class without any annotations.
 * <p>
 * Doxygen produces documentation ONLY up to the method with the annotation.
 * The annotated method an all method after that are missing in the output.<br>
 * <br>
 * <u>Public methods in this class:</u>
 * <ul>
 * <li>{@link #AnnotatedMethod()} - in output</li>
 * <li>{@link #toLowerCaseString(CharSequence)} - NOT in output</li>
 * <li>{@link #toUpperCaseString(CharSequence)} - NOT in output</li>
 * </ul>
 * </p>
 * 
 * @author starfury
 */
public class AnnotatedMethod {

	/**
	 * This is the default constructor.
	 */
	public AnnotatedMethod() {
		// does nothing
	}

	@SuppressWarnings("javadoc")
	public String toLowerCaseString(CharSequence someText) {
		return someText.toString().toLowerCase();
	}

	/**
	 * This method converts the given {@link CharSequence} to
	 * an upper cased string.
	 * 
	 * @param someText The text to be lowercased
	 * @return The text in lower case letters
	 */
	public String toUpperCaseString(CharSequence someText) {
		return someText.toString().toUpperCase();
	}

}