#include "video.h"
#include "globals.h"
#include <string.h>

#include <gst/gst.h>
#include <gst/app/gstappsink.h>
#include <gst/app/gstappsrc.h>
#include <gst/gstcaps.h>

#include <SDL.h>
#include <SDL_video.h>
#include <SDL_image.h>
#include <gstreamer-1.0/gst/gstelement.h>

using namespace std;

//static GstAppSink* app_sink;



/* Callback: The appsink has received a buffer */
static GstFlowReturn new_buffer (GstAppSink *app_sink, gpointer /*data*/, SDL_Rect pos, SDL_Texture *tex, GstSample* sample, GstBuffer *buffer) 
{

    // Get the frame from video stream
    sample = gst_app_sink_pull_sample(app_sink);
    buffer = gst_sample_get_buffer(sample);
    if(!buffer) 
    {
        // Finished playing.
        return GST_FLOW_ERROR;
    }

#if 0
	GstCaps* caps;
        caps = gst_buffer_get_caps (sample);
	printf("caps are %s\n", gst_caps_to_string(caps));
#endif
	static const int BPP = 1;
	// Using a STATIC texture, we can upload this way
        GstMapInfo mapinfo = {0, };
        gst_buffer_map(buffer,&mapinfo,GST_MAP_READ);
	SDL_UpdateTexture(tex, NULL,mapinfo.data ,GST_ROUND_UP_4(pos.w * BPP));


    gst_buffer_unmap(buffer, &mapinfo);
    gst_buffer_unref(buffer);
    return GST_FLOW_OK;
}
static void pad_added_handler (GstElement *src, GstPad *new_pad,  GstAppSink *app_sink ) 
{
    GstPadLinkReturn ret;
    GstCaps *new_pad_caps = NULL;
    GstStructure *new_pad_struct = NULL;
    const gchar *new_pad_type = NULL;
    GstPad *sink_pad_video;
    g_print ("Received new pad '%s' from '%s':\n", GST_PAD_NAME (new_pad), GST_ELEMENT_NAME (src));

    new_pad_caps = gst_pad_query_caps(new_pad,NULL);
    new_pad_struct = gst_caps_get_structure (new_pad_caps, 0);
    new_pad_type = gst_structure_get_name (new_pad_struct);
    if (g_str_has_prefix (new_pad_type, "video/x-raw"))
    {
        sink_pad_video = gst_element_get_static_pad ((GstElement*)app_sink, "sink");
        ret = gst_pad_link (new_pad, sink_pad_video);
        if (GST_PAD_LINK_FAILED (ret)) 
        {
                g_print (" Type is '%s' but link failed.\n", new_pad_type);
        }
        else
        {
                g_print (" Link succeeded (type '%s').\n", new_pad_type);
        }
       gst_object_unref (sink_pad_video);
        } 
        else 
        {
                g_print (" It has type '%s' which is not raw video. Ignoring.\n", new_pad_type);
                gst_caps_unref (new_pad_caps);
        }
        gst_caps_unref (new_pad_caps);
}
static GstElement* makeSource(string uri, GstAppSink *app_sink)
{
        GstElement* source;
        source = gst_element_factory_make ("uridecodebin", "source");
        
	/*SET TO THE MEDIA FILES LOACTION*/
	string uriready = "file:///home/janos/Desktop/"+uri;
        printf("%s \n",uriready.c_str());
        g_object_set(source, "uri", uriready.c_str(), NULL);
        g_signal_connect (source, "pad-added", G_CALLBACK (pad_added_handler), app_sink);
        return source;
}
video::video(int id,string filep,int x,int y,int width,int height,int zindex, int stopable)
{
        filen = filep;
        pos.x = 0;
        pos.y = 0;
        pos.w = width;
        pos.h = height;
        pos2.x = x;
        pos2.y = y;
        pos2.w = width;
        pos2.h = height;
        inited = false;
        rewindtime = 0;
	visible = 0;
}
     
video::~video()
{
    printf("videoclass destruct\n");
    if (inited)
    {
        clean();
    }
}

void video::setrewindtime(int time) 
{
    this->rewindtime = time;
}
void video::init()
{  
    app_sink = (GstAppSink *)gst_element_factory_make ("appsink", "app_sink");
    source = makeSource(this->filen, app_sink);
    pipeline = gst_pipeline_new("test-pipeline");
    if (!gst_bin_add(GST_BIN(pipeline), source)) 
    {
        g_print("Unable to add source element to the pipeline.\n");
        gst_object_unref (pipeline);
        gst_object_unref(source);
        gst_object_unref(app_sink);
        return;
    }
    if (!gst_bin_add(GST_BIN(pipeline), (GstElement *)app_sink)) 
    {
        g_print("Unable to add sink element to the pipeline.\n");
        gst_object_unref (pipeline);
        gst_object_unref(app_sink);
        return;
    }
    tex = SDL_CreateTexture(RENDER, SDL_PIXELFORMAT_IYUV,SDL_TEXTUREACCESS_STATIC, pos.w, pos.h);
    if (gst_element_set_state(pipeline, GST_STATE_PLAYING) == GST_STATE_CHANGE_FAILURE) 
    {
        g_print ("Unable to set the pipeline to the playing state.\n");
        gst_object_unref (pipeline);
        return;
    }
    if (tex == NULL)
    {
        gst_object_unref (pipeline);
        SDL_DestroyTexture(tex);
        return;
    }
    inited = true;
}

void video::update()
{
	if(visible)
	{
		if (!inited)
		{
			init();
    		}
		if ((playb==false && playonceb==false) && inited)
		{
			clean();
		}
                if (playb | playonceb)
		{   
                        if (new_buffer((GstAppSink*)app_sink, 0,this->pos, tex, sample,buffer) != GST_FLOW_OK)
			{
                                if (playonceb) {playonceb = false; clean();}
				if (playb)    
				{
                                   gst_element_seek (pipeline,1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, rewindtime, GST_SEEK_TYPE_NONE, GST_CLOCK_TIME_NONE);
				}

			}
			else 
			{   
				SDL_RenderCopy(RENDER, tex, &pos, &pos2);
			}
		}
	}
}


void video::clean()
{       
	SDL_DestroyTexture(tex);
	gst_element_set_state(pipeline,GST_STATE_NULL);
	gst_object_unref(GST_OBJECT (pipeline));
		// Freeing the pipeline will also free everything inside it (source, sink)
    	inited = false;
	visible = 0;
}

void video::playloop()
{
	playonceb = false;
	playb = true;
	visible = 1;
}

void video::playonce()
{
	playonceb = true;
	playb = false;
	visible = 1;
}

void video::stop()
{
    if (inited)
    {
        playonceb = false;
	playb = false;
	visible = 0;
        clean();
    }
}
int video::getvisible()
{
    return visible;
}
