#! /usr/bin/env python2

from helpers import *

def main(): # {{
    timeline = MyTimeline ()
    timeline.add_track (GES.VideoTrack.new())

    image_layer = timeline.append_layer ()
    main_layer = timeline.append_layer ()

    video_src = GES.UriClipAsset.request_sync (sys.argv[1])
    img_src = GES.UriClipAsset.request_sync (sys.argv[2])

    main_layer.add_asset (video_src, 0, 0, 5 * Gst.SECOND, GES.TrackType.VIDEO)
    image_layer.add_asset (img_src, 0, 0, 3 * Gst.SECOND, GES.TrackType.VIDEO)

    os.system ('rm -f /tmp/out.mp4')
    timeline.my_render ('file:///tmp/out.mp4')
    g_main_loop.run ()

    if os.path.exists ('/tmp/out.mp4'):
        os.system ('vlc /tmp/out.mp4')
    else:
        print 'Failed to create output file'
# }}}

if __name__ == '__main__':
    if len (sys.argv) != 3:
        print 'Usage : {0} <video_uri> <img_uri>'
        exit (1)

    main()
