#!/usr/bin/env python
#!coding: utf-8
import os
import time
import lxml.html
import lxml.etree
import sys
import gtk
import json
import locale
f=open('csatornak.txt', 'r')
csatornak=json.load(f)
f.close()
dialog=gtk.Dialog()
dialog.set_title('Select a television channel')
#dialog.set_border_width(0)
dialog.set_default_size(800, 400)
vbox=gtk.VBox(False, 1)
label=gtk.Label('Select a television channel from the list, and click Show button.')
label.set_line_wrap(True)
vbox.pack_start(label)
label=gtk.Label('_Channels list:')
label.set_use_underline(True)
adolista=list(set(csatornak.keys()))
adolista.sort(cmp=locale.strcoll)
csatornalista=gtk.ListStore(str)
for i in adolista:
    csatornalista.append([i])
csatornavalaszto=gtk.TreeView(model=csatornalista)
renderer = gtk.CellRendererText()
column = gtk.TreeViewColumn('', renderer, text=0)
csatornavalaszto.append_column(column)
csatornavalaszto.set_headers_visible(False)
label.set_mnemonic_widget(csatornavalaszto)
vadjust = csatornavalaszto.get_vadjustment()
scrolledwindow = gtk.ScrolledWindow(None, None)
scrolledwindow.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
scrolledwindow.add(csatornavalaszto)
vbox.pack_start(label)
vbox.pack_start(scrolledwindow)
dialog.get_content_area().add(vbox)
csatornavalaszto.set_search_column(0)
selection = csatornavalaszto.get_selection()
selection.set_mode(gtk.SELECTION_BROWSE)
selection.select_path(0)
dialog.add_button('_Show', 0)
#button.set_flags(gtk.CAN_DEFAULT)
#button.grab_default()
dialog.add_button(gtk.STOCK_CANCEL, 1)
dialog.set_has_separator(True)
dialog.show_all()
answer=dialog.run()
if answer!=0:
    sys.exit()

model, treeiter = csatornavalaszto.get_selection().get_selected()
kivalasztottado=model[treeiter][0]
dialog.set_visible(False)
dialog.destroy()
ora=time.strftime('%H')
perc=time.strftime('%M')
urllista=[]
urllista.append(csatornak[kivalasztottado.decode('utf-8')]['url']+'&i_st_hour='+ora+'&i_st_min='+perc)
urllista.append(csatornak[kivalasztottado.decode('utf-8')]['url']+'&i_days=2&i_box=1')
urllista.append(csatornak[kivalasztottado.decode('utf-8')]['url']+'&i_days=2&i_box=2')
urllista.append(csatornak[kivalasztottado.decode('utf-8')]['url']+'&i_days=3&i_box=1')
urllista.append(csatornak[kivalasztottado.decode('utf-8')]['url']+'&i_days=3&i_box=2')
print 'Kis türelmet, műsorinformációk letöltése folyamatban.'
html=lxml.html.parse(urllista[0])
adocim=html.xpath('//td[@align="center" and @class="txt"]')
adocim2=lxml.etree.tostring(adocim[0], method='text', encoding='utf-8').strip().replace('û', 'ű')
musor_html='<html><head><META HTTP-EQUIV="CONTENT-TYPE" CONTENT="text/html; charset=utf-8"><title>'+adocim2[0:adocim2.find('műsora:')-1]+' csatorna három napi műsora</title></head><body>'
for url in urllista:
    if url!=urllista[0]:
        html=lxml.html.parse(url)
    adatok=html.xpath('//div/table[2]/tr[2]/td/table[2]/table/tr/td')
    musor={}
    musor['musor']=[]
    for k in range(0,len(adatok),2):
        musorinformacio={}
        link=adatok[k+1].xpath('span/a')
        if len(link)==1:
            musorinformacio['link']='http://port.hu/'+link[0].get('href')
        musorinformacio['idopont']=adatok[k].xpath('span')[0].text_content().strip()
        musorinformacio['cim']=adatok[k+1].xpath('span')[0].text_content().strip()
        alelem=adatok[k+1].getchildren()
        musorstring='<p>'
        for informacio in alelem[2:]:
            musorstring=musorstring+lxml.html.tostring(informacio, method='html', encoding='utf-8')
        musorstring=musorstring+'</p>'
        musorinformacio['informacio']=musorstring.decode('utf-8')
        musor['musor'].append(musorinformacio)
    if not url.__contains__('box=2'):
        adocim=html.xpath('//td[@align="center" and @class="txt"]')
        adocim2=lxml.etree.tostring(adocim[0], method='text', encoding='utf-8').strip().replace('û', 'ű')
        musor_html=musor_html+'<h1>'+adocim2+'</h1>'
    for i in musor['musor']:
        if i.has_key('link'):
            musor_html=musor_html+str('<h2><a href="'+i['link'].encode('utf-8')+'">'+i['idopont'].encode('utf-8')+': '+i['cim'].encode('utf-8')+'</a></h2>')
        else:
            musor_html=musor_html+'<h2>'+i['idopont'].encode('utf-8')+': '+i['cim'].encode('utf-8')+'</h2>'
        if i['informacio']!='':
            musor_html=musor_html+i['informacio'].encode('utf-8')+'</p>'
musor_html=musor_html.replace('õ', 'ő')
musor_html=musor_html.replace('Õ', 'Ő')
musor_html=musor_html.replace('û', 'ű')
html2=lxml.html.document_fromstring(musor_html)
f=open('musor.html', 'w')
f.write(lxml.html.tostring(html2, pretty_print=True, encoding='utf-8', include_meta_content_type=True))
print 'Megjelenítés, kis türelmet.'
os.system('firefox musor.html &')
