﻿/** \file aircond.h
    \brief Defines the class 空調設定

*/

/** \brief This class simulates controling air conditions

Simulates controling temperature or humidity.
*/
class 空調設定
{
public:
	/** \brief constructor
	
	\param i気温 set current temperature
	\param i湿度 set current humidity
	*/
	空調設定( int i気温, int i湿度 ) : 気温( i気温 ), 湿度( i湿度 ), 扇風機( false ), ヒーター( false ), クーラー( false )
	{
	}
	
	/** \brief destructor
	
	Only to make this class inheritable. Do nothing.
	*/
	virtual ~空調設定()
	{
	}
	
	/** \brief turn on the fan
	
	Simulate turning on the fan
	*/
	void 扇風機を回す()
	{
		if ( 扇風機 ) { return; }
		扇風機 = true;
		湿度 -= 3;
		return;
	}

	/** \brief turn off the fan
	
	Simulate turning off the fan
	*/
	void 扇風機を止める()
	{
		if ( !扇風機 ) { return; }
		扇風機 = false;
		湿度 += 3;
		return;
	}

	/** \brief turn on the heater
	
	Simulate turning on the heater
		*/
	int ヒーターをつける()
	{
		if ( ヒーター ) { return; }
		ヒーター = true;
		温度 += 5;
		return;
	}
	
	/** \brief turn off the heater
	
	Simulate turning off the heater
		*/
	int ヒーターを切る()
	{
		if ( !ヒーター ) { return; }
		ヒーター = false;
		温度 -= 5;
		return;
	}

	/** \brief turn on the cooler
	
	Simulate turning on the cooler
		*/
	int クーラーをつける()
	{
		if ( クーラー ) { return; }
		クーラー = true;
		温度 -= 5;
		return;
	}
	
	/** \brief turn off the cooler
	
	Simulate turning off the cooler
		*/
	int クーラーを切る()
	{
		if ( !クーラー ) { return; }
		クーラー = false;
		温度 += 5;
		return;
	}

protected:
	int 温度; ///< The temperature
	int 湿度; ///< The humidity
	bool 扇風機; ///< shows the fan is currently working
	bool ヒーター; ///< shows the heater is currently working
	bool クーラー; ///< shows the heater is currently working
};
