﻿/** \mainpage

\tableofcontents

\section MisFixedDetails Misfixed details

See <a href="http://bugzilla.gnome.org/show_bug.cgi?id=705910">Bug 705910</a>.

Dimitri 'fixed' my patch and pushed to Git, as told in 'comment 5' at 15 Sep, 2013, but the
workaround breaks some functionalities given with my original patch.

Fortunatelly, the 1st bug below seems easy to fix. But the 2nd one looks hard to fix from
current Git HEAD.

Sorry to say, Dimitri, please tell me how will you fix this bug. Note that the sort-key feature
I suggested at <a href="http://bugzilla.gnome.org/show_bug.cgi?id=708046">Bug 708046</a> depends
on the patch I posted with 'comment 4' of Bug 705910. I recommend re-patch that.

We still have a chance to simply replace the files below(as my original patch makes), because 
these files are not fixed after Aug 2013, except 'comment 5' workaround above:
<ul>
<li>src/index.cpp</li>
<li>src/search.js</li>
<li>src/search_js.h</li>
<li>src/searchindex.cpp</li>
<li>src/utils.h</li>
<li>... and add src/codepointmap.h</li>
</ul>

And the file fixed only once except the workaround above is:
<ul>
<li>src/utils.cpp</li>
</ul>

\section WrongIndexHeder The quick link on the headers shows 0xHHHH form instead of character

Not only the index of enumerator like the figure.
You can see this bug also in the index of
<a href="functions.html">class members</a>,
<a href="functions_func.html">class functions</a>,
<a href="functions_vars.html">class variables</a>,
<a href="globals.html">file members</a>,
<a href="globals_enum.html">file enumerations</a>,
<a href="globals_eval.html">file enumerators</a>,
<a href="namespacemembers.html">namespace members</a>,
<a href="namespacemembers_enum.html">namespace enumerations</a>,
and
<a href="namespacemembers_eval.html">namespace enumerators</a> ...(and so on?), if the condition meet.

You can see the figures below to go <a href="namespacemembers_eval.html">namespace enumerators</a>.

\subsection WrongCaseIndexHeader Wrong case
\image html quickindex_wrong.png

\subsection CorrectCaseIndexHeader Correct case
\image html quickindex_correct.png

\section InvalidGrouping Any non-ASCII characters should NOT grouping up on indices

In fact, the grouping seems just mis-coding, not conceptional error.

But making new patch seems to be more difficult than re-applying the patch I made before.

You can see the figures below to go <a href="functions.html">class members</a>.

\subsection WrongCaseBadGrouping Wrong case
\image html indexgrouping_wrong.png

\subsection CorrectCaseBadGrouping Correct case
\image html indexgrouping_correct.png

*/