/*! \file Test1.cpp
    \brief The file represents bug 707278

This file is used for representing the issue bug 707278.

*/

/*! \mainpage Issue details

\author Suzumizaki-Kimitaka

\tableofcontents

\section howToRepresents How To Represent the Bug

1) Make sure search target is set to \a All.

\image html selectall.png

2) Type \a Te in search box.

The list will be shown, contains the entries begin with \a Te.
With this documents, the entries are Test1, Test2, Test1.cpp and TestSpace.

Before patch, the search result is shown like the picture below:

\image html before.png

As told in the picture above, the 2nd and the 5th link don't work.

This bug seems appear only when namespace used.

\section WhyNotWork Why not work?

The reason is easy to understand: The generated html is wrong.

\image html reason.png

Each strings used in \a id attribute should be unique in one html/xml
document. But the doxygen generates \a SR_test1 and \a SR_test2 twice.

\section IdealBehavior The Ideal Behavior

After the patch I made is applied, the search result will works ideal.

The Ideal behavior likes the picture below:

\image html after.png

\a Test1 and \a Test2 are grouped into each one entry.
And they are clickable to expand and shrink.

*/

/*! \brief One of important factor to represent this issue

This problem doesn't appear when no namespace is defined.
*/
namespace TestSpace
{

/*! \brief The test class

*/
class Test1
{
public:
	/*! \brief default constructor
	
	The default consturctor.
	Both of internal variables goes to zero.
	*/
	Test1() : mValue1( 0 ), mValue2( 0 ) { }

	/*! \brief the constructor takes 1 argument

	\param value1 the value set to \a mValue1.
	*/
	Test1( int value1 ) : mValue1( value1 ), mValue2( 0 ) { }

	/*! \brief destructor
	
	Only to make this class to inheritable. do nothing.
	*/
	virtual ~Test1() { }

	/*! \brief the 1st value constructor defined
	
	To set this value, use Test1( value1 ) constructor.
	*/
	const int mValue1;
	
	/*! \brief the 2nd value constructor defined
		
	Currently always zero.
	*/
	const int mValue2;
};

/*! \brief The class 2

The 2nd test class.

*/
class Test2
{
public:
	/*! \brief default constructor
	*/
	Test2() : mValue3( 0 ), mValue4( 0 )  { }
	
	/*! \brief the constructor takes 1 argument
	\param value3 the value set to \a mValue3 variable.
	*/
	Test2( int value3 ) : mValue3( value3 ), mValue4( 0 ) { }

	/*! \brief the constructor takes 2 argument

	\param value3 the value set to \a mValue3.
	\param value4 the value set to \a mValue4.
	*/
	Test2( int value3, int value4 ) : mValue3( value3 ), mValue4( value4 ) { }
	
	const int mValue3; ///< \brief the value set by constructor
	const int mValue4; ///< \brief the value set to zero
};





} // namespace TestSpace
