#pragma once

#include <gst/gst.h>

#include <gst/gstinfo.h>
#include <gst/base/gstbasesrc.h>
#include <boost\thread\thread.hpp>
#include <windef.h>

GST_DEBUG_CATEGORY_STATIC (videobox_demo_category);
#define GST_CAT_DEFAULT videobox_demo_category

#define CHUNK_SIZE 1024   /* Amount of bytes we are sending in each buffer */
#define SAMPLE_RATE 44100 /* Samples per second we are sending */

#define AUDIO_CAPS "audio/x-raw, format=(string)S16LE, layout=(string)interleaved, rate=(int)%d, channels=(int)2, channel-mask=(bitmask)0x0000000000000003"

class GstreamerDemo
{
private:
	/* Structure to contain all our information, so we can pass it to callbacks */
	typedef struct _CustomData {
		GstElement *pipeline, *app_source, *queue, *videobox;
		GstElement *visual, *video_convert, *video_sink;

		guint64 num_samples;   /* Number of samples generated so far (for timestamp generation) */
		gfloat a, b, c, d;     /* For waveform generation */
		int i;
		gboolean add;

		guint sourceid;        /* To control the GSource */

		GMainLoop *main_loop;  /* GLib's Main Loop */
	} CustomData;

	CustomData data;

	boost::thread* thread_gstreamer;	// vlakno pre gstloop

	static gboolean push_data(CustomData *data);
	static void start_feed(GstElement *source, guint size, CustomData *data);
	static void stop_feed(GstElement *source, CustomData *data);
	static gboolean error_cb(GstBus *bus, GstMessage *msg, CustomData *data);

	void StartTask();

public:
	GstreamerDemo();
	~GstreamerDemo();
	void init(HWND hwnd);
};