/*
 * MpegTimestampParser.h
 * Air Video Server
 *
 * Copyright 2012 InMethod s.r.o.
 * Author: matej.knopp@inmethod.com
 */

#ifndef MPEG_TIMESTAMP_PARSER_H
#define MPEG_TIMESTAMP_PARSER_H

#include <gst/gst.h>
#include <gst/codecparsers/gstmpegvideoparser.h>

G_BEGIN_DECLS

#define TYPE_MPEG_TIMESTAMP_PARSER            (mpeg_timestamp_parser_get_type())
#define MPEG_TIMESTAMP_PARSER(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_MPEG_TIMESTAMP_PARSER, MpegTimestampParser))
#define MPEG_TIMESTAMP_PARSER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_MPEG_TIMESTAMP_PARSER, MpegTimestampParser))
#define IS_TYPE_MPEG_TIMESTAMP_PARSER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_MPEG_TIMESTAMP_PARSER))
#define IS_TYPE_MPEG_TIMESTAMP_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_MPEG_TIMESTAMP_PARSER))

typedef struct _MpegTimestampParser      MpegTimestampParser;
typedef struct _MpegTimestampParserClass MpegTimestampParserClass;

struct _MpegTimestampParser
{
    GstElement element;
    
    GstPad *sinkpad, *srcpad;
    
    GstMpegVideoSequenceHdr sequence_hdr;
    GstMpegVideoSequenceExt sequence_ext;
    int fps_den;
    int fps_num;
    
    gboolean silent;

    GstBuffer *i_or_p_frame;
    GList *b_frames;
    
    GstClockTime next_dts;
    GstClockTime next_pts;
};

struct _MpegTimestampParserClass
{
    GstElementClass parent_class;
};

GType mpeg_timestamp_parser_get_type(void);

void mpeg_timestamp_parser_register(void);

G_END_DECLS

#endif
