#define ENUM_CLASS enum class

class Glyph
{
public:

	/*! \enum Default
	 * 	Enumerates the predefined glyphs in Visualize.  These can be accessed via the GlyphKit::GetDefault function and their appearance can be seen
	 * 	<a href="http://docs.techsoft3d.com/hps/core_graphics/prog_guide/app/default_glyphs.html">here</a>. */
	ENUM_CLASS Default
	{
		Circle,					//!< An unfilled circle.
		CircleWithDot,			//!< An unfilled circle with a dot in the center.
		CircleWithPlus,			//!< An unfilled circle with a plus sign in the center.
		CircleWithTimes,		//!< An unfilled circle with a times sign (X-shaped) in the center.
		CircleWithCircle,		//!< An unfilled circle with a smaller unfilled circle inside it.
		SolidCircle,	
	};
}

