--! @file
--! @brief Testbench für DUT.
library IEEE;
use IEEE.std_logic_1164.all;

--! Hier kann der gesamte Testbench genauer beschrieben werden.
entity testbench is
end entity testbench;

--! @brief Hier kommt die Beschreibung der Architektur hin.
--! @details Die Architektur kann dann auch ausführlich beschrieben werden.
architecture STR of testbench is
	signal data_out : std_logic_vector(7 downto 0); --! Output Signal vom DUT
	signal data_in  : std_logic_vector(7 downto 0); --! Input Signal für DUT
	signal valid    : std_logic; --! Valid output vom DUT
	signal start    : std_logic; --! Start input für DUT
	signal clk      : std_logic; --! Clock Input
	signal rst      : std_logic; --! Reset Signal
	constant PERIOD : time := 50 ns; --! Half the clock period. The frequency will be 1/(2*PERIOD) = 100 MHz

begin
	
	--! Instanz des Clock generators
	clock_generator_instance : entity work.clock_generator(BEH)
		generic map(
			PERIOD => PERIOD
		)
		port map(
			clk => clk
		);

	--! Instanz des DUT
	dut_instance : entity work.dut(RTL)
		port map(
			data_out => data_out,
			data_in  => data_in,
			valid    => valid,
			start    => start,
			clk      => clk,
			rst      => rst
		);

end architecture STR;
