--! @file
--! @brief Device under Test
--! @details Längere Beschriebung des dut.vhd-File
library IEEE;
use IEEE.std_logic_1164.all;

--! @brief Device under Test (DUT)
--! @details Device zum Testen von Sigasi und Doxygen
entity dut is
	port(
		data_out : out std_logic_vector(7 downto 0); --! Output von DUT
		data_in  : in  std_logic_vector(7 downto 0); --! Input von DUT
		valid    : out std_logic; --! Ausgang valid oder nicht?
		start    : in  std_logic; --! Zähler auf 0 zurücksetzten
		clk      : in  std_logic; --! Clocksignal
		rst      : in  std_logic --! Reset
	);
end entity dut;

--! @brief RTL Architektur von DUT
--! @details Genau beschreibung der RTL Architektur
architecture RTL of dut is
	constant MIN_COUNT : integer := 0; --! Minimaler Counterstand
	constant MAX_COUNT : integer := 5; --! Maximaler Counterstand
	signal count       : integer range 0 to MAX_COUNT; --! Zählvariable

begin
	--! Prozess zur generierung des Outputs (dut::data_out und dut::valid)
	OUTPUT_GENERATOR : process(count, data_in) is
	begin
		if count = MAX_COUNT then
			valid    <= '1';
			data_out <= data_in;
		else
			valid    <= '0';
			data_out <=(others => '0');
		end if;
	end process OUTPUT_GENERATOR;

	--! Prozess zum hochzählen des Counters
	COUNTER : process(clk, rst) is
	begin
		if rst = '1' then
			count <= 0;
		elsif rising_edge(clk) then
			if start = '1' then
				count <= 0;
			elsif count < MAX_COUNT then
				count <= count + 1;
			end if;
		end if;
	end process COUNTER;

end architecture RTL;
