--! @file
--! @brief Ein einfacher Clock-Generator

library IEEE;
use IEEE.std_logic_1164.all;

--! @brief		Clock-Generator
--! @details	Clock-Generator für einen Testbench. Die Periodendauer lässt sich über clock_generator::PERIOD definieren. Das generierte Signal
--!				hat einen Duty-Cycle von 50% und eine Frequenz von 1/(2*PERIOD)
entity clock_generator is
	generic(
		PERIOD : time := 25 ns --! Generische Periodendauer mit Defaultwert 25ns
	);
	port(
		clk : out std_logic --! Clock output
	);
end entity clock_generator;

--! @brief Verhalten des Clock-Generators
architecture BEH of clock_generator is
begin
	--! Prozess zum generieren des Signals
	CLOCK_DRIVER : process is
	begin
		clk <= '0';
		wait for PERIOD / 2;
		clk <= '1';
		wait for PERIOD / 2;
	end process CLOCK_DRIVER;

end architecture BEH;
