///////////////////////////////////////////////////////////////////////////
/// 
/// \addtogroup Log
/// @{
/// \file CLog.h
/// 
/// Hallo Log for the console output. 
/// Here is the detailed description of the class so the application developer
/// knows, what this class is used for
///
/// \copyright (c) Copyright 2012 
///////////////////////////////////////////////////////////////////////////

#ifndef INCLUDEGUARD_CLOG_H
#define INCLUDEGUARD_CLOG_H

///////////////////////////////////////////////////////////////////////////
//  Includes
///////////////////////////////////////////////////////////////////////////
#include "ILog.h"
//#include <string>


///////////////////////////////////////////////////////////////////////////
//  Definitions
///////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////
/// Log for the console output. 
/// Here is the detailed description of the class so the application developer
/// knows, what this class is used for
///////////////////////////////////////////////////////////////////////////
class CLog : public ILog {
    public:
		
		///////////////////////////////////////////////////////////////////////////
		/// brief description of function. 
		/// Details to the function... there might be several lines
		/// to describe the function
		/// 
		/// \param p__nCount Quantity of log entries
		/// \return Number of log entries accepted
		/// \sa other log functions nLogNoDetails and nLogNoDetails2
		/// \note This is the note section
		/// \warning This function is globally synchronized, be careful with high prio threads
		///////////////////////////////////////////////////////////////////////////
		virtual int nLog(int p__nCount);		
		
		
		virtual int nLogNoDetails2(int p__nCount);

		
		///////////////////////////////////////////////////////////////////////////
		/// Add brief description here. Add description here
		/// 
		/// \param p__nFactor Factor to be used for the calcutlation
		/// \return character array with the generated text in UTF8
		/// \warning The text might contain characters not in ASCII
		///////////////////////////////////////////////////////////////////////////
		char* acTest1(int p__nFactor);

		///////////////////////////////////////////////////////////////////////////
		/// brief description of function.		
		/// Details to the function... there might be several lines
		/// to describe the function
		///
		/// \param p__nCount Quantity of log entries
		/// \return Number of log entries accepted
		/// \sa other log functions nLogNoDetails and nLogNoDetails2
		/// \note This is the note section
		/// \warning This function is globally synchronized, be careful with high prio threads
		///////////////////////////////////////////////////////////////////////////
		char* acTest2(int p__nFactor);

		//////////////////////////////////////////////////////////////////////////
		/// brief description of function.
		/// Details to the function... there might be several lines
		/// to describe the function
		///
		/// \param p__nCount Quantity of log entries
		/// \return Number of log entries accepted
		/// \sa other log functions nLogNoDetails and nLogNoDetails2
		/// \note This is the note section
		/// \warning This function is globally synchronized, be careful with high prio threads
		///////////////////////////////////////////////////////////////////////////
		char* acTest3(int p__nFactor);


		virtual int nLogNoDetails(int p__nCount);

    private:

		///////////////////////////////////////////////////////////////////////////
		/// Console log implementaiton. The real implementation of the log functionality
		/// 
		/// \param p__nCount Quantity of log entries
		/// \param p__strFilename Name of the log file
		/// \return Number of log entries accepted
		/// \warning This function is globally synchronized, be careful with high prio threads
		///////////////////////////////////////////////////////////////////////////
		int nLogPrivate(int p__nCount, std::string p__strFilename);

		int m__hFile;  ///< This is the log file handle

};

#endif //INCLUDEGUARD_CLOG_H
/// @} 